/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.model.GroupingInsertMerger;
import net.intelie.pipes.model.GroupingMerger;
import net.intelie.pipes.model.GroupingState;
import net.intelie.pipes.model.TopLevelItemState;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.modules.FallbackToSelect;
import net.intelie.pipes.simple.ItemWindow;
import net.intelie.pipes.types.ItemOutput;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={".toplevel"})
@Help(omit=true)
public class TopLevelExpression
implements Scalar<Iterable> {
    private static final long serialVersionUID = 1L;
    private final GroupBy group;
    private final SelectClause select;
    private final Level level;
    private final Property<Double> timestamp;

    public TopLevelExpression(ArgQueue queue) throws PipeException {
        this.timestamp = queue.context().timestamp();
        this.group = queue.groupBy();
        this.select = TopLevelExpression.makeSelect(queue, new FallbackToSelect("count()"));
        this.level = this.select.level();
    }

    private static SelectClause makeSelect(ArgQueue queue, Fallback<SelectClause> defaultSelect) throws PipeException {
        SelectClause select = (SelectClause)queue.aggregation((Type)Type.ROW).getOptional(SelectClause.class);
        if (select.size() == 0) {
            return (SelectClause)defaultSelect.create(queue);
        }
        return select;
    }

    public TopLevelExpression ensureExpiry() throws PipeException {
        this.group.ensureExpiry();
        return this;
    }

    public SeqType type() {
        return new SeqType((Type)this.rowType());
    }

    public RowType rowType() {
        return new RowType(new RowFields(Row.TIMESTAMP_CLAUSE, this.group.info(), this.select.info()));
    }

    public long ttl() {
        return this.select.ttl();
    }

    public Level level() {
        return this.level;
    }

    public SelectClause select() {
        return this.select;
    }

    public GroupBy group() {
        return this.group;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.select});
        this.group.validate(context);
    }

    public String toString() {
        String groupRepr = this.group.toString();
        String selectRepr = this.select.toString();
        return (selectRepr.trim() + (groupRepr.length() > 0 ? " " + groupRepr : "")).trim();
    }

    public GroupingState newState(int flips) {
        return new GroupingState(flips, this.group, this.select);
    }

    public TopLevelItemState newState(ItemWindow window, ItemOutput output) {
        return new TopLevelItemState(this, window, output);
    }

    public GroupingMerger newMerger() {
        return new GroupingMerger(this.select, !this.group.isEmpty());
    }

    public GroupingInsertMerger newInsertMerger() {
        return new GroupingInsertMerger(this.select, !this.group.isEmpty());
    }

    public RowList eval(Scope parent, Object obj) {
        return new ArrayRowList(new Row[]{this.evalSingle(parent, obj)});
    }

    public ArrayRow evalSingle(Scope parent, Object obj) {
        return ArrayRow.concat((Row[])new Row[]{new ArrayRow(new Object[]{this.timestamp.eval(parent, obj)}), (Row)this.group.eval(parent, obj), (Row)this.select.eval(parent, obj)});
    }

    public RowList eval(Scope parent, Tree tree, WindowBounds bounds) {
        GroupingTree myTree = (GroupingTree)tree;
        ArrayRow first = WindowBoundsImpl.makeRow(bounds);
        return myTree.toRowList(parent, this.select, bounds, first);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.timestamp.visit(parent, visitor);
        this.group.visit(parent, visitor);
        return this.select.visit(parent, visitor);
    }

    public long weight() {
        return ((long)(this.group.size() * 32) + this.select.weight()) * (long)(!this.group.isEmpty() ? 64 : 1);
    }
}

