/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import java.util.Collections;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.SelectState;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.model.GroupingMultiTree;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.ItemWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.types.ItemOutput;

public class TopLevelItemState {
    private final GroupBy group;
    private final SelectClause select;
    private final ItemWindow window;
    private final ItemOutput output;
    private final TopLevelExpression top;
    private final GroupBy.State<InnerState> state;

    public TopLevelItemState(TopLevelExpression top, ItemWindow window, ItemOutput output) {
        this.top = top;
        this.window = window;
        this.output = output;
        this.group = top.group();
        this.select = top.select();
        this.state = this.group.newState(key -> new InnerState((Row)key.toRow()));
    }

    public RowList yield(Scope parent, Long timestamp, Object obj) {
        return ((InnerState)this.state.get(parent, obj)).yield(parent, timestamp, obj);
    }

    public RowList flipAll() {
        ArrayList list = new ArrayList();
        for (InnerState entry : this.state) {
            if (entry.begin == entry.end) continue;
            Iterables.addAll(list, entry.flip());
        }
        if (list.size() > 0) {
            return new ArrayRowList(list);
        }
        return null;
    }

    private class InnerState {
        private final WindowState state;
        private final Row group;
        private final SelectState selected;
        private final State outState;
        private final InsertMerger outMerger;
        private Long max;
        private long begin;
        private long end;

        private InnerState(Row group) {
            this.state = TopLevelItemState.this.window.newState(TopLevelItemState.this.top);
            this.max = null;
            this.begin = 0L;
            this.end = 0L;
            this.group = group;
            this.selected = TopLevelItemState.this.select.newState(0);
            this.outState = TopLevelItemState.this.output.expr() != null ? TopLevelItemState.this.output.expr().newState(0) : null;
            this.outMerger = TopLevelItemState.this.output.expr() != null ? TopLevelItemState.this.output.expr().newInsertMerger() : null;
        }

        public RowList yield(Scope parent, Long timestamp, Object obj) {
            RowList answer = null;
            if (!TopLevelItemState.this.output.after()) {
                answer = this.maybeFlip(parent, obj);
            }
            this.selected.yield(parent, obj);
            ++this.end;
            if (timestamp != null && (this.max == null || timestamp > this.max)) {
                this.max = timestamp;
            }
            if (TopLevelItemState.this.output.after()) {
                answer = this.maybeFlip(parent, obj);
            }
            return answer;
        }

        RowList maybeFlip(Scope parent, Object obj) {
            boolean shouldOutput = true;
            if (this.outState != null) {
                this.outState.yield(parent, obj);
                Tree tree = this.outState.flip();
                this.outMerger.push(tree);
                shouldOutput = (Boolean)TopLevelItemState.this.output.expr().eval(parent, this.outMerger.get(), (WindowBounds)new WindowBoundsImpl(this.max, this.begin, this.end, this.begin, this.end, (int)(this.end - this.begin)));
                if (shouldOutput) {
                    this.outMerger.clear();
                    if (!TopLevelItemState.this.output.after()) {
                        this.outMerger.push(tree);
                    }
                }
            }
            if (this.end - this.begin < (long)TopLevelItemState.this.output.amount() || !shouldOutput) {
                return null;
            }
            return this.flip();
        }

        private RowList flip() {
            GroupingMultiTree tree = new GroupingMultiTree(Collections.singletonMap(this.group, this.selected.flip()));
            RowList rows = this.state.yield(this.max, this.begin, this.end, tree);
            this.begin = this.end;
            this.max = null;
            return rows;
        }
    }
}

