/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.Objects;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.WindowBounds;

public class WindowBoundsImpl
implements WindowBounds {
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final long windowStart;
    private final long windowEnd;
    private final long outputStart;
    private final long outputEnd;
    private final int windowCount;

    public WindowBoundsImpl(Long timestamp, long windowStart, long windowEnd, long outputStart, long outputEnd, int windowCount) {
        this.timestamp = timestamp;
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
        this.outputStart = outputStart;
        this.outputEnd = outputEnd;
        this.windowCount = windowCount;
    }

    public static ArrayRow makeRow(WindowBounds bounds) {
        if (bounds == null || bounds.timestamp() == null) {
            return new ArrayRow(new Object[]{null});
        }
        return new ArrayRow(new Object[]{bounds.timestamp().doubleValue()});
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public long windowStart() {
        return this.windowStart;
    }

    public long windowEnd() {
        return this.windowEnd;
    }

    public long outputStart() {
        return this.outputStart;
    }

    public long outputEnd() {
        return this.outputEnd;
    }

    public int windowCount() {
        return this.windowCount;
    }

    public String toString() {
        return this.timestamp + ": " + this.windowStart + " [" + this.outputStart + " " + this.outputEnd + "] " + this.windowEnd + ": " + this.windowCount + " windows";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowBoundsImpl)) {
            return false;
        }
        WindowBoundsImpl that = (WindowBoundsImpl)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.windowStart, that.windowStart) && Objects.equals(this.windowEnd, that.windowEnd) && Objects.equals(this.outputStart, that.outputStart) && Objects.equals(this.outputEnd, that.outputEnd) && Objects.equals(this.windowCount, that.windowCount);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.windowStart, this.windowEnd, this.outputStart, this.outputEnd, this.windowCount);
    }
}

