/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.util.List;
import java.util.Set;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgGetter;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.FullPipe;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Literal;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.PipeCompiler;
import net.intelie.pipes.PipeCompilers;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.model.FunctionArgument;
import net.intelie.pipes.modules.ArgGetterImpl;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Classes;
import net.intelie.pipes.util.Iterables;

public class ArgQueueImpl
extends ArgGetterImpl<Object>
implements ArgQueue {
    private final AstNode node;
    private final CompilerContext context;
    private final List<AstNode> args;
    private final Index index;

    public ArgQueueImpl(CompilerContext context, List<AstNode> args) {
        this(null, context, args);
    }

    public ArgQueueImpl(AstNode node, CompilerContext context, List<AstNode> args) {
        this(node, context, args, new Index());
    }

    private ArgQueueImpl(AstNode node, CompilerContext context, List<AstNode> args, Index index) {
        super(Object.class);
        this.node = node;
        this.context = context;
        this.args = args;
        this.index = index;
    }

    public SourceLocation location() {
        return SourceLocation.maybeGetFrom((AstNode)this.node);
    }

    public AstNode node() {
        return this.node;
    }

    public CompilerContext context() {
        return this.context;
    }

    public Metadata metadata() {
        return this.context.metadata();
    }

    public ArgQueue withContext(CompilerContext context) {
        return new ArgQueueImpl(this.node, context, this.args, this.index);
    }

    public ArgQueueImpl copy() {
        return new ArgQueueImpl(this.node, this.context, this.args);
    }

    public ArgQueue copyFromHere() {
        return this.copyFrom(this.index.value);
    }

    public ArgQueue copyFrom(int index) {
        ArgQueueImpl queue = this.copy();
        queue.index.value = index;
        return queue;
    }

    public void ensureSafe() throws PipeException {
        PipeException.check((boolean)this.context.metadata().safe(), (Object)"This expression cannot be distributed. Please run it in a safe environment. Consider preceding it with a time aggregation pipe or an '@unsafe' pipe.");
    }

    public GroupBy groupBy() throws PipeException {
        return this.getSafe(GroupBy.class, x -> GroupBy.NONE);
    }

    public PipeCompiler<FullPipe> compiler() {
        return PipeCompilers.get((PropertySource)this.context);
    }

    public int index() {
        return this.index.value;
    }

    public <T> ArgGetter<T> constantValue(final Type<T> exprType) throws PipeException {
        final ArgGetter<Scalar<T>> constant = this.constant(exprType);
        return new ArgGetterImpl<T>(exprType.javaClass()){

            public boolean hasNext() {
                return ArgQueueImpl.this.hasNext();
            }

            public <W extends T> W retry(Fallback<W> fallback) throws PipeException {
                return ArgQueueImpl.this.retry(fallback);
            }

            public <W extends T> W reallyGet(Class<W> clazz, boolean optional, boolean allowNulls, Fallback<? extends W> fallback) throws PipeException {
                Scalar expr = (Scalar)constant.reallyGet(Scalar.class, optional, allowNulls, queue -> new Literal(exprType, fallback.create(queue)));
                Object obj = expr.eval(null, null);
                if (obj == null) {
                    if (optional) {
                        obj = fallback.create((ArgQueue)ArgQueueImpl.this);
                    } else {
                        throw new PipeException((Object)("The parameter #" + ArgQueueImpl.this.index.value + " <" + expr + "> must be a non-null constant."));
                    }
                }
                return clazz.cast(obj);
            }
        };
    }

    public <T> ArgGetter<Expression<T>> expression(Type<T> exprType) throws PipeException {
        return this.next(Level.EXPRESSION.token(exprType));
    }

    public <T> ArgGetter<Aggregation<T>> aggregation(Type<T> exprType) throws PipeException {
        return this.next(Level.AGGREGATION.token(exprType));
    }

    public <T> ArgGetter<Scalar<T>> scalar(Type<T> exprType) throws PipeException {
        return this.next(Level.SCALAR.token(exprType));
    }

    public <T> ArgGetter<Scalar<T>> constant(Type<T> exprType) throws PipeException {
        return this.next(Level.CONSTANT.token(exprType));
    }

    public <T, Q extends Expression<T>> ArgGetter<Q> next(final Level.Token<T, Q> token) throws PipeException {
        final ArgQueueImpl queue = this;
        return new ArgGetterImpl<Q>(token.javaClass()){

            public boolean hasNext() {
                return ArgQueueImpl.this.hasNext();
            }

            public <W extends Q> W retry(Fallback<W> fallback) throws PipeException {
                return (W)((Expression)queue.retry(fallback));
            }

            public <W extends Q> W reallyGet(Class<W> clazz, boolean optional, boolean allowNulls, Fallback<? extends W> fallback) throws PipeException {
                Expression expr = (Expression)queue.reallyGet(Expression.class, optional, allowNulls, fallback);
                if (!NamedExpression.class.equals(clazz) && expr instanceof NamedExpression) {
                    throw new PipeException("Unexpected named or expand parameter #" + ArgQueueImpl.this.index.value + ": '%s'", new Object[]{expr});
                }
                if (expr == null && optional) {
                    return null;
                }
                if (!token.acceptsType(expr)) {
                    throw new PipeException((Object)ArgQueueImpl.makeExceptionMsg(ArgQueueImpl.this.index.value, expr, token.type().displayName(), expr.type().displayName()));
                }
                if (!token.acceptsLevel(expr)) {
                    throw new PipeException((Object)ArgQueueImpl.makeExceptionMsg(ArgQueueImpl.this.index.value, expr, token.level().name(), expr.level().name()));
                }
                return (W)((Expression)ArgQueueImpl.this.ensureType(clazz, expr));
            }
        };
    }

    public static String makeExceptionMsg(int index, Object expr, String expected, String actual) {
        return "The parameter #" + index + " (" + expr + ") must be " + expected + " instead of " + actual + ".";
    }

    public <T> T retry(Fallback<T> fallback) throws PipeException {
        this.index.value = Math.max(this.index.value - 1, 0);
        return (T)fallback.create((ArgQueue)this);
    }

    public boolean hasNext() {
        return this.index.value < this.args.size();
    }

    public Set<String> getNextAnnotations() {
        return FunctionArgument.listAnnotations(this.nextNode());
    }

    private AstNode nextNode() {
        if (!this.hasNext()) {
            return null;
        }
        return this.args.get(this.index.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode node(boolean optional) throws PipeException {
        try {
            AstNode next = FunctionArgument.filterAnnotations(this.nextNode());
            if (next == null) {
                if (optional) {
                    AstNode astNode = null;
                    return astNode;
                }
                throw new PipeException((Object)("Expected parameter #" + (this.index.value + 1) + ". Nothing found."));
            }
            AstNode astNode = next;
            return astNode;
        }
        finally {
            this.index.value++;
        }
    }

    public <Q> Q reallyGet(Class<Q> clazz, boolean optional, boolean allowNulls, Fallback<? extends Q> fallback) throws PipeException {
        AstNode o;
        AstNode node = this.node(optional);
        if (node == null) {
            return (Q)fallback.create((ArgQueue)this);
        }
        Object object = o = AstNode.class.equals(clazz) ? node : this.context.compile(node);
        if (allowNulls && o == null) {
            return (Q)fallback.create((ArgQueue)this);
        }
        return this.ensureType(clazz, o);
    }

    private <Q> Q ensureType(Class<Q> clazz, Object o) throws PipeException {
        if (!clazz.isInstance(o)) {
            throw new PipeException((Object)ArgQueueImpl.makeExceptionMsg(this.index.value, o, clazz.getSimpleName(), Classes.toStringClassOf(o)));
        }
        return clazz.cast(o);
    }

    public void ensureEmpty() throws PipeException {
        if (this.hasNext()) {
            AstNode o = this.args.get(this.index.value);
            throw new PipeException((Object)("Unexpected parameter #" + (this.index.value + 1) + " <" + o + ">"));
        }
    }

    public String toString() {
        return Iterables.join((String)", ", this.args);
    }

    private static class Index {
        private volatile int value = 0;

        private Index() {
        }
    }
}

