/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.FilterContext;
import net.intelie.pipes.FunctionContext;
import net.intelie.pipes.FunctionContextList;
import net.intelie.pipes.HelpCollection;
import net.intelie.pipes.Literal;
import net.intelie.pipes.MapPropertySource;
import net.intelie.pipes.Module;
import net.intelie.pipes.ModuleContext;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyGroup;
import net.intelie.pipes.PropertyReplacer;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.LiteralNode;
import net.intelie.pipes.ast.PropertyNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.model.FunctionArgument;
import net.intelie.pipes.modules.CallArgsImpl;
import net.intelie.pipes.modules.FunctionSet;
import net.intelie.pipes.modules.PlaceholderProperty;
import net.intelie.pipes.modules.StandardModule;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.util.PipeCache;

public class CompilerContextImpl
implements CompilerContext {
    private static final long serialVersionUID = 1L;
    private static final FunctionSet DEFAULT_SET = CompilerContextImpl.defaultSet();
    private final CompilerContext parent;
    private final PropertySource defaultNames;
    private final PropertySource names;
    private final FunctionSet functions;
    private final FilterContext filterContext;
    private final FunctionContextList functionContext;
    private final ModuleContext moduleContext;
    private final PipeCache<AstNode, Object> compileCache = new PipeCache<AstNode, Object>(4096, this::uncachedCompile);

    public CompilerContextImpl() {
        this((PropertySource)new MapPropertySource());
    }

    public CompilerContextImpl(PropertySource names) {
        this(names, null);
    }

    public CompilerContextImpl(PropertySource names, FunctionSet functions) {
        this(null, null, names, functions, null, null, null);
    }

    private CompilerContextImpl(CompilerContext parent, PropertySource defaultNames, PropertySource names, FunctionSet functions, FilterContext filterContext, FunctionContextList functionContext, ModuleContext moduleContext) {
        if (defaultNames == null) {
            defaultNames = names;
        }
        if (functions == null) {
            functions = DEFAULT_SET;
        }
        if (functionContext == null) {
            functionContext = new FunctionContextList(names.metadata());
        }
        if (moduleContext == null) {
            moduleContext = new ModuleContext();
        }
        this.parent = parent;
        this.functions = functions;
        this.defaultNames = defaultNames;
        this.names = names;
        this.filterContext = filterContext;
        this.functionContext = functionContext;
        this.moduleContext = moduleContext;
    }

    public static FunctionSet defaultSet() {
        FunctionSet declarers = new FunctionSet();
        declarers.addModule(StandardModule.instance());
        return declarers;
    }

    public static CompilerContext createIfNeeded(PropertySource source) {
        if (source == null) {
            return new CompilerContextImpl();
        }
        return source instanceof CompilerContext ? (CompilerContext)source : new CompilerContextImpl(source);
    }

    public FunctionContext functionContext() {
        return this.functionContext.getContext();
    }

    public ModuleContext moduleContext() {
        return this.moduleContext;
    }

    public Object compile(AstNode node) throws PipeException {
        node = FunctionArgument.filterAnnotations(node);
        return this.compileCache.get(node);
    }

    private Object uncachedCompile(AstNode node) throws PipeException {
        if (node instanceof CallNode) {
            CallNode call = (CallNode)node;
            return this.resolveFunction(node, call.getLocation(), call.getName(), call.getArgs());
        }
        if (node instanceof PropertyNode) {
            return this.resolveProperty((PropertyNode)node);
        }
        if (node instanceof RawNode) {
            return ((RawNode)node).getValue();
        }
        if (node instanceof LiteralNode) {
            LiteralNode literal = (LiteralNode)node;
            return new Literal(literal.getType(), literal.getValue());
        }
        throw new PipeException("Unknown node type: %s", new Object[]{node});
    }

    private Object resolveFunction(AstNode node, SourceLocation location, String name, List<AstNode> args) throws PipeException {
        try {
            ArrayList<String> imports = new ArrayList<String>();
            if (!this.moduleContext.isDefault()) {
                imports.add(this.moduleContext.getName());
            }
            return this.functions.create(imports, name, new CallArgsImpl(node, (CompilerContext)this, args));
        }
        catch (PipeException e) {
            throw e.maybeAddSource(location);
        }
    }

    /*
     * Loose catch block
     */
    private Object resolveProperty(PropertyNode node) throws PipeException {
        try {
            AstNode other;
            if (node.getTarget() == null && node.getName() != null && (other = this.functionContext.getContext().resolveProperty(node.getName(), node.hasArgs(), node.getArgs())) != null) {
                return this.compile(other);
            }
            ArrayList<AstNode> innerArgs = new ArrayList<AstNode>();
            innerArgs.add(node.getTarget());
            innerArgs.add((AstNode)LiteralNode.newString((Object)node.getName()));
            innerArgs.add((AstNode)LiteralNode.newBoolean((Object)node.hasArgs()));
            innerArgs.addAll(node.getArgs());
            return this.resolveFunction((AstNode)node, node.getLocation(), ".property", innerArgs);
        }
        catch (PipeException e) {
            if (node.getTarget() != null) {
                throw e;
            }
            PipeException saved = e;
            try {
                return this.resolveFunction((AstNode)node, node.getLocation(), ".hat", Collections.singletonList(new PropertyNode(node.getLocation(), null, node.getName(), node.hasArgs(), node.getArgs())));
            }
            catch (PipeException e2) {
                throw saved;
            }
            {
                catch (PipeException e3) {
                    throw e3.maybeAddSource(node.getLocation());
                }
            }
        }
    }

    public CompilerContext getParentSource() throws PipeException {
        if (this.parent == null) {
            throw new PipeException((Object)"Unable to find parent context for ^hat operator");
        }
        return this.parent;
    }

    public CompilerContext optimize() {
        return new CompilerContextImpl(this.parent, this.defaultNames, this.names, this.functions.optimize(), this.filterContext, this.functionContext, this.moduleContext);
    }

    public CompilerContext insideModule(ModuleContext moduleContext) {
        return new CompilerContextImpl(this.parent, this.defaultNames, this.names, this.functions, this.filterContext, this.functionContext, moduleContext);
    }

    public CompilerContext insideFunction(FunctionContext arguments) throws PipeException {
        return new CompilerContextImpl(this.parent, this.defaultNames, this.names, this.functions, this.filterContext, this.functionContext.insideFunction(arguments), this.moduleContext).addModule(arguments.makeModule());
    }

    public FilterContext filterContext() {
        return this.filterContext;
    }

    public CompilerContext insideFilter(FilterContext filterContext) {
        return new CompilerContextImpl(this.parent, this.defaultNames, this.names, this.functions, filterContext, this.functionContext, this.moduleContext);
    }

    public List<PropertyGroup> defaultProperties() {
        if (this.parent != null) {
            return Collections.singletonList(new PropertyGroup((Property)new PlaceholderProperty(this.names.metadata().type(), new Scalar[0])));
        }
        return this.names.defaultProperties();
    }

    public Property property() throws PipeException {
        if (this.parent != null) {
            return new PlaceholderProperty(this.metadata().type(), new Scalar[0]);
        }
        return this.names.property();
    }

    public Property property(String name) throws PipeException {
        return this.names.property(name);
    }

    public String toString() {
        return "<context>";
    }

    public Metadata metadata() {
        return this.names.metadata();
    }

    public CompilerContext addModule(Module module) {
        FunctionSet newDeclarers = this.functions.copy();
        newDeclarers.addModule(module);
        return new CompilerContextImpl(this.parent, this.defaultNames, this.names, newDeclarers, this.filterContext, this.functionContext, this.moduleContext);
    }

    public CompilerContext newSource(Metadata metadata) throws PipeException {
        return new CompilerContextImpl(this.parent, this.defaultNames, this.makeNames(metadata), this.functions, this.filterContext, this.functionContext.makeChild(metadata), this.moduleContext);
    }

    public CompilerContext newChildSource(Metadata metadata) throws PipeException {
        return new CompilerContextImpl(this, this.defaultNames, this.makeNames(metadata), this.functions, this.filterContext, this.functionContext.makeChild(metadata), this.moduleContext);
    }

    private PropertySource makeNames(Metadata metadata) throws PipeException {
        return this.defaultNames.newSource(metadata);
    }

    public Property<Double> timestamp() throws PipeException {
        return this.names.timestamp();
    }

    public PropertyReplacer makeReplacer() {
        return this.names.makeReplacer();
    }

    public HelpCollection help() {
        return this.functions.help();
    }
}

