/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Explodable;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.LiteralNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.util.Classes;
import net.intelie.pipes.util.ConstantHelper;

public abstract class ExplosionHelper {
    public static List<AstNode> explode(CompilerContext config, List<AstNode> args) throws PipeException {
        ArrayList<AstNode> copy = new ArrayList<AstNode>();
        for (AstNode arg : args) {
            if (ExplosionHelper.isExplode(arg)) {
                ExplosionHelper.explodeToIterable(copy, config, (CallNode)arg);
                continue;
            }
            copy.add(arg);
        }
        return copy;
    }

    private static void explodeToIterable(List<AstNode> copy, CompilerContext config, CallNode node) throws PipeException {
        PipeException.check((node.getArgs().size() == 2 ? 1 : 0) != 0, (String)"%s nodes must have exactly two arguments. This one has: %s", (Object[])new Object[]{".explode", node.getArgs().size()});
        Number index = ExplosionHelper.getIndex(config, Number.class, (AstNode)node.getArgs().get(0));
        Object obj = config.compile((AstNode)node.getArgs().get(1));
        ExplosionHelper.explodeExpression(copy, obj, index.intValue(), true);
    }

    private static void explodeExpression(List<AstNode> list, Object obj, int levels, boolean require) throws PipeException {
        if (levels > 0 && obj instanceof Explodable) {
            for (Object child : ((Explodable)obj).explode()) {
                ExplosionHelper.explodeExpression(list, child, levels - 1, false);
            }
            return;
        }
        if (ConstantHelper.isConstant((Object)obj)) {
            ExplosionHelper.explodeConstantValue(list, ConstantHelper.evaluate((Expression)((Expression)obj)), levels, require);
            return;
        }
        ExplosionHelper.verifyRequire(obj, levels, require);
        list.add((AstNode)new RawNode(obj));
    }

    private static void verifyRequire(Object obj, int levels, boolean require) throws PipeException {
        PipeException.check((levels <= 0 || !require ? 1 : 0) != 0, (String)"Unable to explode sequence in compile-time. Required Explodable or constant Iterable. Found: %s (%s)", (Object[])new Object[]{obj, Classes.toStringClassOf(obj)});
    }

    private static void explodeConstantValue(List<AstNode> list, Object obj, int levels, boolean require) throws PipeException {
        if (levels > 0 && obj instanceof Iterable) {
            for (Object child : (Iterable)obj) {
                ExplosionHelper.explodeConstantValue(list, child, levels - 1, false);
            }
            return;
        }
        ExplosionHelper.verifyRequire(obj, levels, require);
        list.add((AstNode)LiteralNode.newAuto((Object)obj));
    }

    private static <T> T getIndex(CompilerContext config, Class<T> clazz, AstNode node) throws PipeException {
        Object index = config.compile(node);
        PipeException.check((boolean)ConstantHelper.isConstant((Object)index), (String)"Compiled exploded index must be a constant, it is '%s'", (Object[])new Object[]{index});
        Object value = ConstantHelper.evaluate((Expression)((Expression)index));
        PipeException.check((boolean)clazz.isInstance(value), (String)("Compiled exploded index must be instance of " + clazz.getName() + ", it is '%s' (%s)."), (Object[])new Object[]{value, Classes.toStringClassOf(value)});
        return clazz.cast(value);
    }

    private static boolean isExplode(AstNode arg) {
        return arg instanceof CallNode && ".explode".equals(((CallNode)arg).getName());
    }
}

