/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CallArgs;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpCollection;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Module;
import net.intelie.pipes.ModuleContext;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.functions.StringOps;
import net.intelie.pipes.util.ConstantHelper;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Levenshtein;

public class FunctionSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<Function>> map = new HashMap<String, List<Function>>();
    private final FunctionSet parent;

    public FunctionSet() {
        this(null);
    }

    private FunctionSet(FunctionSet parent) {
        this.parent = parent;
    }

    public FunctionSet copy() {
        return new FunctionSet(this);
    }

    public FunctionSet optimize() {
        if (this.parent == null) {
            return this;
        }
        return this.innerOptimize();
    }

    private FunctionSet innerOptimize() {
        FunctionSet optimized = this.parent != null ? this.parent.innerOptimize() : new FunctionSet();
        this.map.entrySet().stream().flatMap(x -> ((List)x.getValue()).stream()).forEach(optimized::addFunction);
        return optimized;
    }

    public void addModule(Module module) {
        for (Function function : module.functions()) {
            this.addFunction(function);
        }
    }

    public void addFunction(Function function) {
        List list = this.map.computeIfAbsent(function.name(), k -> new ArrayList());
        if (function.name().startsWith("@@")) {
            list.clear();
        }
        list.add(function);
    }

    public Object create(String name, CallArgs args) throws PipeException {
        return this.create(Collections.emptyList(), name, args);
    }

    public Object create(List<String> imports, String name, CallArgs args) throws PipeException {
        ArrayList<String> matched = new ArrayList<String>();
        ArrayList<String> failures = new ArrayList<String>();
        Object result = this.tryResolve(imports, name, args, matched, failures);
        return this.checkResult(name, args, result, matched, failures);
    }

    private Object tryResolve(List<String> imports, String name, CallArgs args, List<String> matched, List<String> failures) throws PipeException {
        Object result = null;
        FunctionSet set = this;
        do {
            result = set.tryResolve(result, name, args, matched, failures);
            for (String module : imports) {
                result = set.tryResolve(result, ModuleContext.prefixName((String)module, (String)name), args, matched, failures);
            }
        } while ((set = set.parent) != null && (!name.startsWith("@@") || matched.size() == 0));
        return result;
    }

    private Object tryResolve(Object result, String name, CallArgs args, List<String> matched, List<String> failures) throws PipeException {
        Collection functions = this.map.get(name);
        if (functions == null) {
            return result;
        }
        for (Function function : functions) {
            try {
                ArgQueue queue = args.queue();
                Object o = function.declare(queue);
                queue.ensureEmpty();
                result = o;
                matched.add(function.description());
            }
            catch (Exception e) {
                if (e instanceof PipeException && ((PipeException)((Object)e)).location() != null) {
                    throw e;
                }
                failures.add(function.description() + ": " + FunctionSet.reprException(e));
            }
        }
        return result;
    }

    private Object checkResult(String name, CallArgs args, Object result, List<String> matched, List<String> failures) throws PipeException {
        if (matched.size() == 0) {
            if (failures.size() == 0) {
                throw this.noSuchFunction(name);
            }
            throw FunctionSet.multipleErrors(name, args, failures);
        }
        if (matched.size() > 1) {
            throw FunctionSet.callAmbiguity(name, args, matched);
        }
        if (ConstantHelper.isConstant((Object)result)) {
            result = ConstantHelper.simplify((Expression)((Expression)result));
        }
        return result;
    }

    private static String withTypes(String name, CallArgs args) {
        return StringOps.truncate(args.toString(name), 64.0, "...");
    }

    private static PipeException callAmbiguity(String name, CallArgs args, List<String> matched) {
        return new PipeException((Object)("Call ambiguity for " + FunctionSet.withTypes(name, args) + ". \nFound: " + Iterables.join((String)", ", matched)));
    }

    private static PipeException multipleErrors(String name, CallArgs args, List<String> messages) {
        return new PipeException((Object)("Error in call " + FunctionSet.withTypes(name, args) + ", cause(s):\n" + Iterables.join((String)"\n- or -\n", messages)));
    }

    private PipeException noSuchFunction(String name) {
        return Levenshtein.makeExc((String)name, this.map.keySet(), (String)"No such function: '%s'.%s");
    }

    private static String reprException(Exception e) {
        if (e instanceof PipeException) {
            return e.getMessage();
        }
        return "(" + e.getClass().getSimpleName() + ") " + e.getMessage();
    }

    public HelpCollection help() {
        LinkedHashSet<HelpData> list = new LinkedHashSet<HelpData>();
        this.fillHelp(list);
        return new HelpCollection(new ArrayList<HelpData>(list));
    }

    private void fillHelp(LinkedHashSet<HelpData> list) {
        if (this.parent != null) {
            this.parent.fillHelp(list);
        }
        for (List<Function> functions : this.map.values()) {
            for (Function value : functions) {
                HelpData help = value.help();
                if (help == null || this.startsWith(help.name(), ".") || this.startsWith(help.docKey(), "operator-")) continue;
                list.add(help);
            }
        }
    }

    private boolean startsWith(String target, String str) {
        return target != null && target.startsWith(str);
    }
}

