/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.CustomizeFunction;
import net.intelie.pipes.Function;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.modules.method.CustomizeFunctionWrapper;
import net.intelie.pipes.modules.method.MethodFunction;
import net.intelie.pipes.types.Type;

public class InstanceModule
implements Module {
    private static final long serialVersionUID = 1L;
    private final List<Function> list;
    private final String repr;

    public InstanceModule(Object module) throws PipeException {
        this(module, null, null);
    }

    public InstanceModule(Object module, ClassLoader loader) throws PipeException {
        this(module, loader, null);
    }

    public InstanceModule(Object module, ClassLoader loader, Map<String, Type<?>> argTypes) throws PipeException {
        this.repr = "instance methods of " + module.getClass().getName();
        this.list = InstanceModule.create(module, loader, argTypes);
    }

    public static List<Function> create(Object module, ClassLoader loader, Map<String, Type<?>> argTypes) throws PipeException {
        ArrayList<Function> list = new ArrayList<Function>();
        for (Method method : module.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            list.addAll(MethodFunction.create(method, module, loader, argTypes));
        }
        if (module instanceof CustomizeFunction) {
            CustomizeFunction customize = (CustomizeFunction)module;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, new CustomizeFunctionWrapper((Function)list.get(i), customize));
            }
        }
        return list;
    }

    public Iterable<Function> functions() {
        return this.list;
    }

    public String toString() {
        return this.repr;
    }
}

