/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.util.Arrays;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.ObjectSink;
import net.intelie.pipes.guava.collect.ObjectArrays;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.GetUtils;

public class PlaceholderProperty
implements Property {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final Scalar[] args;

    public PlaceholderProperty(Type type, Scalar ... args) {
        this.type = type != null ? type : Type.OBJECT;
        this.args = args;
    }

    public String name() {
        return "_";
    }

    public Iterable<Scalar> args() {
        return Arrays.asList(this.args);
    }

    public PlaceholderProperty indexed(Scalar ... args) throws PipeException {
        return new PlaceholderProperty(GetUtils.inferType((Type)this.type, (Expression[])args), ObjectArrays.concat(this.args, args, Scalar.class));
    }

    public void evalRaw(Scope parent, Object obj, ObjectSink sink) {
        sink.onSingle(obj);
    }

    public boolean sameProperty(Property other) {
        return other instanceof PlaceholderProperty && this.type.equals((Object)((PlaceholderProperty)other).type);
    }

    public PlaceholderProperty hint(Type type) throws PipeException {
        return new PlaceholderProperty(type, this.args);
    }

    public boolean requiresObjectFix() {
        return false;
    }

    public Object eval(Scope parent, Object obj) {
        for (Scalar arg : this.args) {
            obj = GetUtils.get((Object)obj, (Object[])new Object[]{arg.eval(parent, obj)});
        }
        return this.type.cast(obj);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (Scalar arg : this.args) {
            arg.visit(parent, visitor);
        }
        return visitor.anyProperty();
    }

    public Type type() {
        return this.type;
    }
}

