/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.Function;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.modules.method.MethodFunction;
import net.intelie.pipes.types.Type;

public class StaticModule
implements Module {
    private static final long serialVersionUID = 1L;
    private final List<Function> list = new ArrayList<Function>();
    private final String repr;

    public StaticModule(Class module) throws PipeException {
        this(module, null);
    }

    public StaticModule(Class module, ClassLoader loader) throws PipeException {
        this(module, loader, null);
    }

    public StaticModule(Class module, ClassLoader loader, Map<String, Type<?>> argTypes) throws PipeException {
        this.repr = "static methods of " + module.getName();
        for (Method method : module.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.list.addAll(MethodFunction.create(method, null, loader, argTypes));
        }
    }

    public Iterable<Function> functions() {
        return this.list;
    }

    public String toString() {
        return this.repr;
    }
}

