/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.constructor;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicLong;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.jitescript.CodeBlock;
import net.intelie.pipes.jitescript.JiteClass;
import net.intelie.pipes.jitescript.util.CodegenUtils;
import net.intelie.pipes.modules.constructor.CompiledConstructor;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.util.Preconditions;

public abstract class ConstructorCompiler {
    private static final AtomicLong count = new AtomicLong(0L);

    public static CompiledConstructor optimize(Class<?> clazz) throws PipeException {
        try {
            boolean without = ConstructorCompiler.testConstructor(clazz, ArgQueue.class);
            boolean with = ConstructorCompiler.testConstructor(clazz, ArgQueue.class, ResolverState.class);
            Preconditions.checkArgument((with || without ? 1 : 0) != 0, (String)"Cannot optimize %s: no suitable public constructor", (Object[])new Object[]{clazz.getName()});
            return (CompiledConstructor)ConstructorCompiler.defineClass(clazz, with, without).newInstance();
        }
        catch (Exception e) {
            throw PipeException.handle((Throwable)e);
        }
    }

    private static boolean testConstructor(Class<?> clazz, Class<?> ... args) {
        try {
            Constructor<?> constructor = clazz.getConstructor(args);
            return (constructor.getModifiers() & 1) > 0 && (constructor.getDeclaringClass().getModifiers() & 1) > 0;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Class<?> defineClass(final Class<?> clazz, final boolean with, final boolean without) throws Exception {
        String className = "constructor" + count.incrementAndGet() + "$" + clazz.getSimpleName();
        JiteClass jite = new JiteClass(className, new String[]{CodegenUtils.p(CompiledConstructor.class)}){
            {
                super(x0, x1);
                this.defineDefaultConstructor();
                this.defineMethod("create", 17, CodegenUtils.sig(Object.class, ArgQueue.class), without ? ConstructorCompiler.defaultWithout(clazz) : ConstructorCompiler.fallbackToWith(clazz));
                this.defineMethod("create", 17, CodegenUtils.sig(Object.class, ArgQueue.class, ResolverState.class), with ? ConstructorCompiler.defaultWith(clazz) : ConstructorCompiler.defaultWithout(clazz));
                this.defineMethod("toString", 1, CodegenUtils.sig(String.class, new Class[0]), CodeBlock.newCodeBlock().ldc("<" + clazz.getSimpleName() + ">").areturn());
            }
        };
        return new DynamicClassLoader(clazz.getClassLoader()).define(jite);
    }

    private static CodeBlock fallbackToWith(Class<?> clazz) {
        return CodeBlock.newCodeBlock().newobj(CodegenUtils.p(clazz)).dup().aload(1).invokestatic(CodegenUtils.p(ResolverState.Empty.class), "instance", CodegenUtils.sig(ResolverState.class, new Class[0])).invokespecial(CodegenUtils.p(clazz), "<init>", CodegenUtils.sig(Void.TYPE, ArgQueue.class, ResolverState.class)).areturn();
    }

    private static CodeBlock defaultWith(Class<?> clazz) {
        return CodeBlock.newCodeBlock().newobj(CodegenUtils.p(clazz)).dup().aload(1).aload(2).invokespecial(CodegenUtils.p(clazz), "<init>", CodegenUtils.sig(Void.TYPE, ArgQueue.class, ResolverState.class)).areturn();
    }

    private static CodeBlock defaultWithout(Class<?> clazz) {
        return CodeBlock.newCodeBlock().newobj(CodegenUtils.p(clazz)).dup().aload(1).invokespecial(CodegenUtils.p(clazz), "<init>", CodegenUtils.sig(Void.TYPE, ArgQueue.class)).areturn();
    }

    public static class DynamicClassLoader
    extends ClassLoader {
        public DynamicClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> define(JiteClass jiteClass) {
            byte[] classBytes = jiteClass.toBytes();
            return super.defineClass(CodegenUtils.c(jiteClass.getClassName()), classBytes, 0, classBytes.length);
        }
    }
}

