/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.constructor;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Function;
import net.intelie.pipes.Help;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.modules.constructor.CompiledConstructor;
import net.intelie.pipes.modules.constructor.ConstructorCompiler;
import net.intelie.pipes.util.Classes;
import net.intelie.pipes.util.Documentation;

public class ConstructorModule
implements Module {
    private static final long serialVersionUID = 1L;
    private final Help help;
    private final List<Function> functions;
    private final String repr;
    private final String overrideName;

    public ConstructorModule(Class<?> clazz) throws PipeException {
        this(null, clazz);
    }

    public ConstructorModule(String overrideName, Class<?> clazz) throws PipeException {
        ConstructorModule.makeConstructor(clazz);
        this.overrideName = overrideName;
        this.help = clazz.getAnnotation(Help.class);
        this.functions = this.makeFunctions(clazz);
        this.repr = "constructor of " + clazz.getName();
    }

    private static CompiledConstructor makeConstructor(Class<?> clazz) throws PipeException {
        try {
            clazz.getConstructor(ArgQueue.class);
            return ConstructorCompiler.optimize(clazz);
        }
        catch (Exception e) {
            throw PipeException.handle((Throwable)e);
        }
    }

    private ArrayList<Function> makeFunctions(Class<?> clazz) throws PipeException {
        String[] names = this.getNames(clazz);
        ArrayList<Function> list = new ArrayList<Function>();
        for (String name : names) {
            list.add(new MyFunction(name, clazz));
        }
        return list;
    }

    private String[] getNames(Class<?> clazz) throws PipeException {
        if (this.overrideName != null) {
            return new String[]{this.overrideName};
        }
        Export export = clazz.getAnnotation(Export.class);
        if (export == null || export.value().length == 0) {
            throw new PipeException("Class %s must define @Export annotation with at least one valid name", new Object[]{clazz});
        }
        return export.value();
    }

    public Iterable<Function> functions() {
        return this.functions;
    }

    public String toString() {
        return this.repr;
    }

    private class MyFunction
    implements Function {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Class<?> clazz;
        private final String description;
        private transient CompiledConstructor constructor;

        public MyFunction(String name, Class<?> clazz) throws PipeException {
            this.name = name;
            this.clazz = clazz;
            this.description = Classes.toStringClass(clazz);
        }

        private CompiledConstructor getConstructor() throws PipeException {
            if (this.constructor == null) {
                this.constructor = ConstructorModule.makeConstructor(this.clazz);
            }
            return this.constructor;
        }

        public Object declare(ArgQueue queue) throws PipeException {
            try {
                Object o = this.getConstructor().create(queue);
                queue.ensureEmpty();
                return o;
            }
            catch (Throwable e) {
                throw PipeException.handle((Throwable)e);
            }
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public HelpData help() {
            return Documentation.current().makeHelp(this.name(), ConstructorModule.this.help, HelpData.EMPTY);
        }
    }
}

