/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.method;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Tree;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.method.CompiledMethod;
import net.intelie.pipes.modules.method.FreeMethod;

public class BoundMethod
implements Serializable,
CompiledMethod {
    private static final long serialVersionUID = 1L;
    private static final CompiledMethod.Safe SAFE = new CompiledMethod.Safe();
    private final FreeMethod method;
    private final Expression[] exprs;
    private transient boolean init = false;
    private transient CompiledMethod compiled = null;

    public BoundMethod(FreeMethod method, Expression ... exprs) {
        this.method = method;
        this.exprs = exprs;
        this.compiled();
    }

    public CompiledMethod compiled() {
        try {
            if (this.compiled == null) {
                if (this.init) {
                    return SAFE;
                }
                this.init = true;
                this.compiled = this.method.compile(this.exprs);
            }
            return this.compiled;
        }
        catch (Exception e) {
            Logger.getLogger(BoundMethod.class.getName()).log(Level.WARNING, "Uncaught exception", e);
            return SAFE;
        }
    }

    @Override
    public final Object eval(Scope scope, Tree tree, WindowBounds bounds) {
        return this.compiled().eval(scope, tree, bounds);
    }

    @Override
    public final Object eval(Scope scope, Object obj) {
        return this.compiled().eval(scope, obj);
    }
}

