/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.method;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicLong;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Tree;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.guava.cache.CacheBuilder;
import net.intelie.pipes.guava.cache.CacheLoader;
import net.intelie.pipes.guava.cache.LoadingCache;
import net.intelie.pipes.jitescript.CodeBlock;
import net.intelie.pipes.jitescript.JiteClass;
import net.intelie.pipes.jitescript.util.CodegenUtils;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.modules.method.CompiledMethod;
import net.intelie.pipes.modules.method.MethodTree;
import net.intelie.pipes.util.Preconditions;

public class FreeMethod
implements Serializable {
    private static final AtomicLong count = new AtomicLong(0L);
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = false;
    private final transient ClassLoader loader;
    private final Object target;
    private final String name;
    private final Class<?> declared;
    private final Class<?> returnType;
    private final Class<?>[] params;
    private final Class<?> varargs;
    private transient Method method;
    private transient LoadingCache<Integer, Constructor> cache;

    public FreeMethod(Method method, Object target, ClassLoader loader) {
        this.method = method;
        this.target = target;
        this.loader = loader;
        this.name = method.getName();
        this.returnType = method.getReturnType();
        this.declared = method.getDeclaringClass();
        this.params = method.getParameterTypes();
        method.setAccessible(true);
        this.varargs = this.params.length > 0 && this.params[this.params.length - 1].isArray() ? this.params[this.params.length - 1].getComponentType() : null;
    }

    public Class<?> getDeclaringClass() {
        return this.declared;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() throws Exception {
        if (this.cache == null) {
            this.cache = CacheBuilder.newBuilder().maximumSize(8L).build(new CacheLoader<Integer, Constructor>(){

                @Override
                public Constructor load(Integer key) throws Exception {
                    return FreeMethod.this.defineClass(key).getConstructor(Object.class, Expression[].class);
                }
            });
        }
        if (this.method == null) {
            Method thisMethod = this.declared.getDeclaredMethod(this.name, this.params);
            thisMethod.setAccessible(true);
            this.method = thisMethod;
        }
        return this.method;
    }

    public CompiledMethod compile(Expression ... exprs) throws PipeException {
        try {
            this.getMethod();
            return (CompiledMethod)this.cache.get(exprs.length).newInstance(this.target, exprs);
        }
        catch (Exception e) {
            throw PipeException.handle((Throwable)e);
        }
    }

    private Class<?> defineClass(final int length) throws Exception {
        Preconditions.checkArgument((!this.method.getReturnType().isPrimitive() ? 1 : 0) != 0, (Object)"Method return type must be non-primitive.");
        Preconditions.checkArgument((boolean)this.method.isAccessible());
        final String className = "method" + count.incrementAndGet() + "$" + this.declared.getSimpleName() + "$" + this.name;
        JiteClass jite = new JiteClass(className, new String[]{CodegenUtils.p(CompiledMethod.class)}){
            {
                super(x0, x1);
                this.defineField("exprs", 18, CodegenUtils.ci(Expression[].class), null);
                this.defineField("target", 18, CodegenUtils.ci(Object.class), null);
                this.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, Object.class, Expression[].class), CodeBlock.newCodeBlock().aload(0).invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0])).aload(0).aload(1).putfield(className, "target", CodegenUtils.ci(Object.class)).aload(0).aload(2).putfield(className, "exprs", CodegenUtils.ci(Expression[].class)).voidreturn());
                this.defineMethod("eval", 17, CodegenUtils.sig(Object.class, Scope.class, Object.class), FreeMethod.this.methodBody(className, true, length));
                this.defineMethod("eval", 17, CodegenUtils.sig(Object.class, Scope.class, Tree.class, WindowBounds.class), FreeMethod.this.methodBody(className, false, length));
                this.defineMethod("toString", 1, CodegenUtils.sig(String.class, new Class[0]), CodeBlock.newCodeBlock().ldc("<" + FreeMethod.this.declared.getSimpleName() + "." + FreeMethod.this.name + ">").areturn());
            }
        };
        return new DynamicClassLoader(this.loader != null ? this.loader : this.getClass().getClassLoader()).define(jite);
    }

    private CodeBlock methodBody(String className, boolean scalar, int length) throws Exception {
        CodeBlock code = CodeBlock.newCodeBlock();
        return code.trycatch(CodegenUtils.p(Throwable.class), () -> {
            this.prepareArgs(code, className, scalar, length);
            this.properInvoke(code).areturn();
        }, () -> {
            if (DEBUG) {
                code.invokevirtual(CodegenUtils.p(Throwable.class), "printStackTrace", CodegenUtils.sig(Void.TYPE, new Class[0]));
            } else {
                code.pop();
            }
            code.aconst_null().areturn();
        });
    }

    private CodeBlock properInvoke(CodeBlock code) {
        if (Modifier.isStatic(this.method.getModifiers())) {
            return code.invokestatic(CodegenUtils.p(this.declared), this.name, CodegenUtils.sig(this.returnType, this.params));
        }
        return code.invokevirtual(CodegenUtils.p(this.declared), this.name, CodegenUtils.sig(this.returnType, this.params));
    }

    private CodeBlock prepareArgs(CodeBlock code, String className, boolean scalar, int length) {
        int i;
        if (!Modifier.isStatic(this.method.getModifiers())) {
            code = code.aload(0).getfield(className, "target", CodegenUtils.ci(Object.class)).checkcast(CodegenUtils.p(this.declared));
        }
        for (i = 0; i < this.params.length - (this.varargs != null ? 1 : 0); ++i) {
            code = FreeMethod.prepareArg(code, className, i, this.params[i], scalar);
        }
        if (this.varargs != null) {
            code.pushInt(length - this.params.length + 1);
            code.anewarray(CodegenUtils.p(this.varargs));
            for (i = this.params.length - 1; i < length; ++i) {
                code.dup().pushInt(i - this.params.length + 1);
                FreeMethod.prepareArg(code, className, i, this.varargs, scalar);
                code.arraystore();
            }
        }
        return code;
    }

    private static CodeBlock prepareArg(CodeBlock code, String className, int i, Class<?> paramType, boolean scalar) {
        code = code.aload(0).getfield(className, "exprs", CodegenUtils.ci(Expression[].class)).pushInt(i).aaload().checkcast(scalar ? CodegenUtils.p(Scalar.class) : CodegenUtils.p(Aggregation.class)).aload(1).aload(2);
        if (!scalar) {
            code.checkcast(CodegenUtils.p(MethodTree.class)).getfield(CodegenUtils.p(MethodTree.class), "trees", CodegenUtils.ci(Tree[].class)).pushInt(i).aaload().aload(3).checkcast(CodegenUtils.p(WindowBoundsImpl.class));
        }
        if (scalar) {
            code.invokeinterface(CodegenUtils.p(Scalar.class), "eval", CodegenUtils.sig(Object.class, Scope.class, Object.class)).checkcast(CodegenUtils.p(paramType));
        } else {
            code.invokeinterface(CodegenUtils.p(Aggregation.class), "eval", CodegenUtils.sig(Object.class, Scope.class, Tree.class, WindowBounds.class)).checkcast(CodegenUtils.p(paramType));
        }
        return code;
    }

    public static class DynamicClassLoader
    extends ClassLoader {
        public DynamicClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> define(JiteClass jiteClass) {
            byte[] classBytes = jiteClass.toBytes();
            return super.defineClass(CodegenUtils.c(jiteClass.getClassName()), classBytes, 0, classBytes.length);
        }
    }
}

