/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.method;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Cacheable;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Inject;
import net.intelie.pipes.Literal;
import net.intelie.pipes.MacroModule;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.Typed;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.WithType;
import net.intelie.pipes.guava.base.Strings;
import net.intelie.pipes.guava.math.IntMath;
import net.intelie.pipes.modules.ArgQueueImpl;
import net.intelie.pipes.modules.constructor.CompiledConstructor;
import net.intelie.pipes.modules.constructor.ConstructorCompiler;
import net.intelie.pipes.types.DirectTypeResolver;
import net.intelie.pipes.types.MultiTypeResolver;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeContravariance;
import net.intelie.pipes.types.TypeResolver;
import net.intelie.pipes.util.Iterables;

public class MethodArgument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean varargs;
    private final String inject;
    private final Class<?> cached;
    private final List<TypeResolver> types;
    private transient CompiledConstructor constructor;

    public MethodArgument(Class<?> clazz, Annotation[] annotations, boolean isLast) throws PipeException {
        boolean varargs = false;
        Class<?> cached = null;
        ArrayList<TypeResolver> types0 = new ArrayList<TypeResolver>();
        ArrayList<TypeResolver> types1 = new ArrayList<TypeResolver>();
        ArrayList<TypeResolver> types2 = new ArrayList<TypeResolver>();
        ArrayList<TypeResolver> types3 = new ArrayList<TypeResolver>();
        String inject = null;
        if (isLast && clazz.isArray()) {
            clazz = clazz.getComponentType();
            varargs = true;
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof WithType) {
                types1.add(Type.resolver((String)((WithType)annotation).value()));
            }
            if (annotation instanceof TypeParam) {
                for (String s : ((TypeParam)annotation).value()) {
                    types2.add(this.toResolver(s, ((TypeParam)annotation).enforce()));
                }
            }
            if (annotation instanceof Typed) {
                for (String s : ((Typed)annotation).value()) {
                    types3.add(Type.resolver((String)s));
                }
            }
            if (!(annotation instanceof Inject)) continue;
            inject = ((Inject)annotation).value();
        }
        if (Cacheable.class.isAssignableFrom(clazz)) {
            cached = clazz;
        } else {
            types0.add(DirectTypeResolver.create((Type)(inject == null ? Type.inferFromClassExact(clazz) : Type.inferFromClass(clazz))));
        }
        this.varargs = varargs;
        this.inject = inject;
        this.cached = cached;
        this.types = this.resolveResolvers(types0, types1, types2, types3);
        this.initConstructor();
    }

    private void initConstructor() throws PipeException {
        if (this.cached != null && this.constructor == null) {
            this.constructor = ConstructorCompiler.optimize(this.cached);
        }
    }

    public void resolveExpressions(ArgQueue queue, ResolverState state, List<Expression> args, List<String> reprs) throws PipeException {
        if (!this.varargs) {
            this.resolveSingle(queue, state, args, reprs, this.types.get(0));
        } else {
            while (queue.hasNext()) {
                for (TypeResolver resolver : this.types) {
                    this.resolveSingle(queue, state, args, reprs, resolver);
                }
            }
        }
    }

    private void resolveSingle(ArgQueue queue, ResolverState state, List<Expression> args, List<String> reprs, TypeResolver resolver) throws PipeException {
        String repr;
        Type type;
        int index = queue.index();
        Expression expr = null;
        if (this.cached != null) {
            Object cacheable = this.createCachedInstance(queue, state);
            String cacheableRepr = cacheable != null ? cacheable.toString() : null;
            expr = new Literal((Type)Type.OBJECT, cacheable);
            type = cacheable instanceof TypedCacheable ? ((TypedCacheable)cacheable).type() : Type.OBJECT;
            repr = cacheableRepr;
        } else if (this.inject != null) {
            expr = (Expression)queue.compiler().expression().withModule((Module)new MacroModule(args.toArray())).compileToQueue(new String[]{this.inject}).expression((Type)Type.OBJECT).get();
            type = expr.type();
            repr = null;
        } else {
            expr = (Expression)queue.expression((Type)Type.OBJECT).get();
            type = expr.type();
            repr = String.valueOf(expr);
        }
        try {
            resolver.update(type, state);
        }
        catch (Exception e) {
            TypeResolver simple = TypeContravariance.simplify((TypeResolver)resolver.removeWildcards(state));
            throw new PipeException((Object)(ArgQueueImpl.makeExceptionMsg(index + 1, expr, "'" + simple.toString() + "'", "'" + type.name() + "'") + " (" + e.getMessage() + ")"));
        }
        args.add(expr);
        if (!Strings.isNullOrEmpty(repr)) {
            reprs.add(repr);
        }
    }

    private Object createCachedInstance(ArgQueue queue, ResolverState state) throws PipeException {
        this.initConstructor();
        try {
            return this.constructor.create(queue, state);
        }
        catch (Exception e) {
            throw PipeException.handle((Throwable)e);
        }
    }

    @SafeVarargs
    private final List<TypeResolver> resolveResolvers(List<TypeResolver> ... resolvers) {
        int total = this.lcm(resolvers);
        ArrayList<TypeResolver> answer = new ArrayList<TypeResolver>();
        for (int i = 0; i < total; ++i) {
            ArrayList<TypeResolver> list = new ArrayList<TypeResolver>();
            for (List<TypeResolver> resolver : resolvers) {
                if (resolver.size() == 0) continue;
                list.add(resolver.get(i % resolver.size()));
            }
            answer.add((TypeResolver)new MultiTypeResolver(list));
        }
        return answer;
    }

    private int lcm(List<TypeResolver>[] resolvers) {
        int total = 1;
        int gcd = 1;
        for (List<TypeResolver> resolver : resolvers) {
            int size = Math.max(1, resolver.size());
            total *= size;
            gcd = IntMath.gcd(gcd, size);
        }
        return total /= gcd;
    }

    private TypeResolver toResolver(String name, boolean enforce) throws PipeException {
        return Type.resolver((String)((enforce ? "!" : "$") + name));
    }

    public String usageRepr() {
        if (this.inject != null || this.cached != null) {
            return null;
        }
        if (this.types.size() == 1) {
            return this.varargsDots(Iterables.join((String)", ", (Iterable)this.types.stream().map(x -> "<" + x + ">").collect(Collectors.toList())));
        }
        return this.varargsDots("(" + Iterables.join((String)", ", (Iterable)this.types.stream().map(x -> "<" + x + ">").collect(Collectors.toList())) + ")");
    }

    private String varargsDots(String s) {
        return this.varargs ? s + "..." : s;
    }

    public String toString() {
        if (this.inject != null) {
            return this.varargsDots("<injected " + this.inject + ">");
        }
        if (this.cached != null) {
            return this.varargsDots("<cached>");
        }
        if (this.types.size() == 1) {
            return this.varargsDots(Iterables.join((String)", ", this.types));
        }
        return this.varargsDots("(" + Iterables.join((String)", ", this.types) + ")");
    }
}

