/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.method;

import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.method.BoundMethod;
import net.intelie.pipes.modules.method.FreeMethod;
import net.intelie.pipes.modules.method.MethodTree;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

public class MethodExpression<T>
implements Scalar<T> {
    private static final long serialVersionUID = 1L;
    private final String repr;
    private final BoundMethod method;
    private final Expression<?>[] args;
    private final Type<T> type;
    private final Level level;
    private final long ttl;
    private final long weight;

    public MethodExpression(String repr, Type<T> type, Level level, FreeMethod method, Expression[] args) throws PipeException {
        this.repr = repr;
        this.args = args;
        this.method = new BoundMethod(method, args);
        this.type = type;
        this.level = Level.min((Level[])new Level[]{level, Level.min((Expression[])args)});
        this.ttl = MethodExpression.initTtl(args);
        this.weight = MethodExpression.initWeight(args);
    }

    private static long initTtl(Expression[] args) {
        long ttl = 1L;
        for (Expression arg : args) {
            ttl = Math.max(ttl, arg.ttl());
        }
        return ttl;
    }

    private static long initWeight(Expression[] args) {
        long weight = 8 * (2 + args.length) + 32;
        for (Expression arg : args) {
            weight += arg.weight();
        }
        return weight;
    }

    public State newState(int flips) {
        return new MyState(flips);
    }

    public FullMerger newMerger() {
        return new MyFullMerger();
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public T eval(Scope parent, Object obj) {
        return (T)this.type.cast(this.method.eval(parent, obj));
    }

    public Type<T> type() {
        return this.type;
    }

    public Level level() {
        return this.level;
    }

    public long ttl() {
        return this.ttl;
    }

    public long weight() {
        return this.weight;
    }

    public String toString() {
        return this.repr;
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        return (T)this.type.cast(this.method.eval(parent, tree, bounds));
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(this.args);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (Expression<?> expr : this.args) {
            expr.visit(parent, visitor);
        }
        return visitor.newScope();
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MethodTree> {
        private final InsertMerger[] mergers;

        private MyInsertMerger() {
            this.mergers = new InsertMerger[MethodExpression.this.args.length];
            for (int i = 0; i < MethodExpression.this.args.length; ++i) {
                this.mergers[i] = Level.asAggregation((Expression)MethodExpression.this.args[i]).newInsertMerger();
            }
        }

        public void pushQ(MethodTree tree) {
            InsertMerger.pushMany((InsertMerger[])this.mergers, (Tree[])tree.trees);
        }

        public void clear() {
            InsertMerger.clearMany((InsertMerger[])this.mergers);
        }

        public MethodTree get() {
            return new MethodTree(InsertMerger.getMany((InsertMerger[])this.mergers));
        }
    }

    private class MyFullMerger
    extends FullMerger.Base<MethodTree> {
        private final FullMerger[] mergers;

        private MyFullMerger() {
            this.mergers = new FullMerger[MethodExpression.this.args.length];
            for (int i = 0; i < MethodExpression.this.args.length; ++i) {
                this.mergers[i] = Level.asAggregation((Expression)MethodExpression.this.args[i]).newMerger();
            }
        }

        public void pushQ(MethodTree tree) {
            InsertMerger.pushMany((FullMerger[])this.mergers, (Tree[])tree.trees);
        }

        public void pop() {
            FullMerger.popMany((FullMerger[])this.mergers);
        }

        public void clear() {
            InsertMerger.clearMany((FullMerger[])this.mergers);
        }

        public MethodTree get() {
            return new MethodTree(InsertMerger.getMany((FullMerger[])this.mergers));
        }
    }

    private class MyState
    implements State {
        private State[] states;

        private MyState(int flips) {
            this.states = new State[MethodExpression.this.args.length];
            for (int i = 0; i < MethodExpression.this.args.length; ++i) {
                this.states[i] = Level.asAggregation((Expression)MethodExpression.this.args[i]).newState(flips);
            }
        }

        public void yield(Scope parent, Object obj) {
            for (State state : this.states) {
                state.yield(parent, obj);
            }
        }

        public Tree flip() {
            Tree[] trees = new Tree[this.states.length];
            for (int i = 0; i < this.states.length; ++i) {
                trees[i] = this.states[i].flip();
            }
            return new MethodTree(trees);
        }
    }
}

