/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.modules.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.DoNotOptimize;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Function;
import net.intelie.pipes.Help;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Representation;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.Typed;
import net.intelie.pipes.WithType;
import net.intelie.pipes.modules.method.FreeMethod;
import net.intelie.pipes.modules.method.MethodArgument;
import net.intelie.pipes.modules.method.MethodExpression;
import net.intelie.pipes.types.DirectTypeResolver;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.MultiTypeResolver;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeContravariance;
import net.intelie.pipes.types.TypeResolver;
import net.intelie.pipes.util.Documentation;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class MethodFunction
implements Function {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final FreeMethod method;
    private final boolean instance;
    private final Level level;
    private final Representation repr;
    private final TypeResolver returnTypeResolver;
    private final Help help;
    private final String description;
    private final Map<String, Type<?>> argTypes;
    private final List<MethodArgument> arguments;

    public MethodFunction(String name, Method method, Object target) throws PipeException {
        this(name, method, target, null, null);
    }

    public MethodFunction(String name, Method method, Object target, ClassLoader loader, Map<String, Type<?>> argTypes) throws PipeException {
        Preconditions.checkNotNull((Object)method, (Object)"must have method");
        Preconditions.checkNotNull((Object)name, (Object)"must have name");
        PipeException.check((Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) ? 1 : 0) != 0, (String)"Must be a public method inside a public static class: %s.%s", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName()});
        this.name = name;
        this.method = new FreeMethod(method, target, loader);
        this.argTypes = argTypes != null ? argTypes : new HashMap();
        this.instance = !Modifier.isStatic(method.getModifiers());
        this.level = method.getAnnotation(DoNotOptimize.class) != null ? Level.SCALAR : Level.CONSTANT;
        this.help = method.getAnnotation(Help.class);
        this.returnTypeResolver = this.decideReturnTypeParam(method);
        this.repr = method.getAnnotation(Representation.class);
        this.arguments = this.makeArguments(method);
        this.description = this.makeDescription();
    }

    private List<MethodArgument> makeArguments(Method method) throws PipeException {
        ArrayList<MethodArgument> arguments = new ArrayList<MethodArgument>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            arguments.add(new MethodArgument(parameter.getType(), annotations[i], i + 1 == parameters.length));
        }
        return arguments;
    }

    public static List<MethodFunction> create(Method method, Object target, ClassLoader loader, Map<String, Type<?>> argTypes) throws PipeException {
        Export annotation = method.getAnnotation(Export.class);
        if (annotation == null) {
            return Collections.emptyList();
        }
        String[] names = annotation.value();
        if (names.length == 0) {
            names = new String[]{method.getName()};
        }
        ArrayList<MethodFunction> functions = new ArrayList<MethodFunction>();
        for (String name : names) {
            functions.add(new MethodFunction(name, method, target, loader, argTypes));
        }
        return functions;
    }

    private TypeResolver decideReturnTypeParam(Method method) throws PipeException {
        String[] value;
        ArrayList<TypeResolver> resolvers = new ArrayList<TypeResolver>();
        if (method.isAnnotationPresent(WithType.class)) {
            resolvers.add(Type.resolver((String)method.getAnnotation(WithType.class).value()));
        }
        if (method.isAnnotationPresent(Typed.class)) {
            for (String s : method.getAnnotation(Typed.class).value()) {
                resolvers.add(Type.resolver((String)s));
            }
        }
        if (method.isAnnotationPresent(TypeParam.class) && (value = method.getAnnotation(TypeParam.class).value()).length > 0) {
            resolvers.add(Type.resolver((String)("$" + value[0])));
        }
        resolvers.add(DirectTypeResolver.create((Type)Type.inferFromClassExact(method.getReturnType())));
        return new MultiTypeResolver(resolvers);
    }

    public Object declare(ArgQueue queue) throws PipeException {
        ResolverState.Map state = new ResolverState.Map(new HashMap(this.argTypes));
        ArrayList<Expression> args = new ArrayList<Expression>();
        ArrayList<String> repr = new ArrayList<String>();
        for (MethodArgument argument : this.arguments) {
            argument.resolveExpressions(queue, (ResolverState)state, args, repr);
        }
        Type<?> type = this.decideReturnType((ResolverState)state);
        queue.ensureEmpty();
        return new MethodExpression(this.decideRepr(repr), type, this.level, this.method, args.toArray(new Expression[0]));
    }

    private Type<?> decideReturnType(ResolverState state) throws PipeException {
        return TypeContravariance.simplify((TypeResolver)this.returnTypeResolver.removeWildcards(state)).resolve(state);
    }

    private String decideRepr(List<String> args) {
        if (this.repr != null) {
            return String.format(null, this.repr.value(), Iterables.toArray(args, Object.class));
        }
        return this.name + "(" + Iterables.join((String)", ", args) + ")";
    }

    public String description() {
        return this.description;
    }

    private String makeDescription() {
        ArrayList<String> reprs = new ArrayList<String>();
        for (MethodArgument argument : this.arguments) {
            reprs.add(argument.toString());
        }
        return this.method.getDeclaringClass().getSimpleName() + (this.instance ? "#" : ".") + this.method.getName() + "(" + Iterables.join((String)", ", reprs) + ")";
    }

    public String makeDefaultUsage(String name) {
        ArrayList<String> reprs = new ArrayList<String>();
        for (MethodArgument argument : this.arguments) {
            reprs.add(argument.usageRepr());
        }
        TypeResolver simplifiedReturn = TypeContravariance.simplify((TypeResolver)this.returnTypeResolver);
        return name + "(" + Iterables.join((String)", ", reprs) + ") \u2192 <" + simplifiedReturn + ">";
    }

    public String name() {
        return this.name;
    }

    public HelpData help() {
        return Documentation.current().makeHelp(this.name, this.help, new HelpData("function", this.name, this.makeDefaultUsage(this.name), null, null, null, null, null));
    }
}

