/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingInsertMerger;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.BatchWindow;
import net.intelie.pipes.simple.ItemWindow;
import net.intelie.pipes.simple.TimeWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.WindowInfo;

public class OverAllWindow
implements TimeWindow,
ItemWindow,
BatchWindow {
    private static final long serialVersionUID = 0L;

    @Override
    public WindowState newState(TopLevelExpression query) {
        return new MyWindowState(query);
    }

    @Override
    public long estimateMultiplier(Period period) {
        return 1L;
    }

    @Override
    public long estimateMultiplier(int amount) {
        return 1L;
    }

    @Override
    public WindowInfo info(Period output) {
        return WindowInfo.NONE;
    }

    @Override
    public WindowInfo info(int amount) {
        return WindowInfo.NONE;
    }

    public String toString() {
        return "over all";
    }

    public boolean equals(Object o) {
        return o instanceof OverAllWindow;
    }

    public int hashCode() {
        return 365114984;
    }

    private class MyWindowState
    implements WindowState {
        private final GroupingInsertMerger merger;
        private final TopLevelExpression query;
        private GroupingTree tree = null;
        private long minn = Long.MAX_VALUE;
        private long maxx = 0L;
        private int windows = 0;

        public MyWindowState(TopLevelExpression query) {
            this.query = query;
            this.merger = query.newInsertMerger();
        }

        @Override
        public RowList yield(Long timestamp, long start, long end, GroupingTree rows) {
            this.minn = Math.min(this.minn, start);
            this.maxx = Math.max(this.maxx, end);
            if (this.tree != null) {
                this.merger.push((Tree)this.tree);
            }
            this.merger.push((Tree)rows);
            this.tree = this.merger.get();
            this.merger.clear();
            ++this.windows;
            return this.query.eval(null, (Tree)this.tree, new WindowBoundsImpl(timestamp, this.minn, this.maxx, start, end, this.windows));
        }
    }
}

