/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.io.Serializable;
import java.util.Objects;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingInsertMerger;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.BatchWindow;
import net.intelie.pipes.simple.ItemWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.Preconditions;

public abstract class OverCurrentCountWindow
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int amount;

    public OverCurrentCountWindow(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (String)"Item amount can not have non-positive amount: %s", (Object[])new Object[]{amount});
        this.amount = amount;
    }

    public WindowState newState(TopLevelExpression query) {
        return new MyWindowState(query);
    }

    public WindowInfo info(int amount) {
        return WindowInfo.NONE;
    }

    public String toString(String singular, String plural) {
        return "over current " + this.amount + " " + (this.amount > 1 ? plural : singular);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverCurrentCountWindow)) {
            return false;
        }
        OverCurrentCountWindow that = (OverCurrentCountWindow)o;
        return Objects.equals(this.amount, that.amount) && Objects.equals(this.getClass(), that.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.getClass());
    }

    public long estimateMultiplier(int amount) {
        return 1L;
    }

    private class MyWindowState
    implements WindowState {
        private final TopLevelExpression query;
        private final GroupingInsertMerger merger;
        private int windows = 0;
        private long lastLower = -1L;

        public MyWindowState(TopLevelExpression query) {
            this.query = query;
            this.merger = query.newInsertMerger();
        }

        @Override
        public RowList yield(Long timestamp, long start, long end, GroupingTree rows) {
            long lowerBound = start / (long)OverCurrentCountWindow.this.amount * (long)OverCurrentCountWindow.this.amount;
            long upperBound = lowerBound + (long)OverCurrentCountWindow.this.amount;
            if (this.lastLower != lowerBound) {
                this.lastLower = lowerBound;
                this.windows = 0;
                this.merger.clear();
            }
            this.merger.push((Tree)rows);
            ++this.windows;
            return this.query.eval(null, (Tree)this.merger.get(), new WindowBoundsImpl(timestamp, lowerBound, upperBound, start, end, this.windows));
        }
    }

    public static class Batch
    extends OverCurrentCountWindow
    implements BatchWindow {
        private static final long serialVersionUID = 0L;

        public Batch(int amount) {
            super(amount);
        }

        public String toString() {
            return super.toString("batch", "batches");
        }
    }

    public static class Item
    extends OverCurrentCountWindow
    implements ItemWindow {
        private static final long serialVersionUID = 0L;

        public Item(int amount) {
            super(amount);
        }

        public String toString() {
            return super.toString("item", "items");
        }
    }
}

