/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.util.Objects;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingInsertMerger;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.TimeWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.OverCurrentInfo;
import net.intelie.pipes.types.WindowInfo;

public class OverCurrentTimeWindow
implements TimeWindow {
    private static final long serialVersionUID = 0L;
    private final Period period;

    public OverCurrentTimeWindow(Period period) throws PipeException {
        if (!period.supportsFloor()) {
            throw new PipeException("Period '%s' doesn't support alignment", new Object[]{period});
        }
        this.period = period;
    }

    @Override
    public WindowState newState(TopLevelExpression query) {
        return new MyWindowState(query);
    }

    public String toString() {
        return "over current " + this.period;
    }

    @Override
    public long estimateMultiplier(Period period) {
        return 1L;
    }

    @Override
    public long estimateMultiplier(int amount) {
        return 1L;
    }

    @Override
    public WindowInfo info(Period output) {
        return new OverCurrentInfo(this.period, output);
    }

    @Override
    public WindowInfo info(int amount) {
        return new OverCurrentInfo(this.period);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverCurrentTimeWindow)) {
            return false;
        }
        OverCurrentTimeWindow that = (OverCurrentTimeWindow)o;
        return Objects.equals(this.period, that.period);
    }

    public int hashCode() {
        return Objects.hash(this.period);
    }

    private class MyWindowState
    implements WindowState {
        private final GroupingInsertMerger merger;
        private final TopLevelExpression query;
        private int windows = 0;
        private long lastLower = -1L;

        public MyWindowState(TopLevelExpression query) {
            this.query = query;
            this.merger = query.newInsertMerger();
        }

        @Override
        public RowList yield(Long timestamp, long start, long end, GroupingTree rows) {
            long lowerBound = OverCurrentTimeWindow.this.period.floor(timestamp - 1L);
            long upperBound = OverCurrentTimeWindow.this.period.add(lowerBound);
            if (this.lastLower != lowerBound) {
                this.lastLower = lowerBound;
                this.windows = 0;
                this.merger.clear();
            }
            this.merger.push((Tree)rows);
            ++this.windows;
            return this.query.eval(null, (Tree)this.merger.get(), new WindowBoundsImpl(timestamp, lowerBound, upperBound, start, end, this.windows));
        }
    }
}

