/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.io.Serializable;
import java.util.Objects;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingMerger;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.BatchWindow;
import net.intelie.pipes.simple.ItemWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.LongQueue;
import net.intelie.pipes.util.Preconditions;

public abstract class OverLastCountWindow
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int amount;

    public OverLastCountWindow(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (String)"Item amount can not have non-positive amount: %s", (Object[])new Object[]{amount});
        this.amount = amount;
    }

    public WindowState newState(TopLevelExpression query) {
        return new MyWindowState(query);
    }

    public long estimateMultiplier(int amount) {
        return this.amount / amount + (this.amount % amount == 0 ? 0 : 1);
    }

    public WindowInfo info(int amount) {
        return WindowInfo.NONE;
    }

    public String toString(String singular, String plural) {
        return "over last " + this.amount + " " + (this.amount > 1 ? plural : singular);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverLastCountWindow)) {
            return false;
        }
        OverLastCountWindow that = (OverLastCountWindow)o;
        return Objects.equals(this.amount, that.amount) && Objects.equals(this.getClass(), that.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.getClass());
    }

    private class MyWindowState
    implements WindowState {
        private final LongQueue queue = new LongQueue();
        private final GroupingMerger merger;
        private final TopLevelExpression query;

        public MyWindowState(TopLevelExpression query) {
            this.query = query;
            this.merger = query.newMerger();
        }

        @Override
        public RowList yield(Long timestamp, long start, long end, GroupingTree rows) {
            long lowerBound = Math.max(end - (long)OverLastCountWindow.this.amount, 0L);
            this.queue.enqueue(start);
            this.merger.push((Tree)rows);
            while (!this.queue.isEmpty() && this.queue.peek() < lowerBound) {
                this.queue.dequeue();
                this.merger.pop();
            }
            return this.query.eval(null, (Tree)this.merger.get(), new WindowBoundsImpl(timestamp, lowerBound, end, start, end, this.queue.size()));
        }
    }

    public static class Batch
    extends OverLastCountWindow
    implements BatchWindow {
        private static final long serialVersionUID = 0L;

        public Batch(int amount) {
            super(amount);
        }

        public String toString() {
            return super.toString("batch", "batches");
        }
    }

    public static class Item
    extends OverLastCountWindow
    implements ItemWindow {
        private static final long serialVersionUID = 0L;

        public Item(int amount) {
            super(amount);
        }

        public String toString() {
            return super.toString("item", "items");
        }
    }
}

