/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import net.intelie.pipes.GroupingTree;

public class OverLastQueue {
    private int head = 0;
    private int tail = 0;
    private GroupingTree[] list;
    private long[] ids;

    public OverLastQueue() {
        this(16);
    }

    public OverLastQueue(int size) {
        this.list = new GroupingTree[size];
        this.ids = new long[size];
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void enqueue(long key, GroupingTree tree) {
        while (this.next(this.tail) == this.head) {
            this.grow();
        }
        this.list[this.tail] = tree;
        this.ids[this.tail] = key;
        this.tail = this.next(this.tail);
    }

    private int next(int index) {
        return (index + 1) % this.list.length;
    }

    private void grow() {
        int size = this.size();
        int newSize = this.list.length + (this.list.length << 1);
        GroupingTree[] newList = new GroupingTree[newSize];
        long[] newIds = new long[newSize];
        System.arraycopy(this.list, this.head, newList, 0, this.list.length - this.head);
        System.arraycopy(this.list, 0, newList, this.list.length - this.head, this.head);
        System.arraycopy(this.ids, this.head, newIds, 0, this.ids.length - this.head);
        System.arraycopy(this.ids, 0, newIds, this.ids.length - this.head, this.head);
        this.head = 0;
        this.tail = size;
        this.list = newList;
        this.ids = newIds;
    }

    public long headKey() {
        return this.ids[this.head];
    }

    public int size() {
        return (this.tail - this.head + this.list.length) % this.list.length;
    }

    public GroupingTree dequeue() {
        GroupingTree rows = this.list[this.head];
        this.list[this.head] = null;
        this.head = this.next(this.head);
        return rows;
    }
}

