/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.util.Objects;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingMerger;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.TimeWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.OverLastInfo;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.LongQueue;

public class OverLastTimeWindow
implements TimeWindow {
    private static final long serialVersionUID = 0L;
    private final Period period;

    public OverLastTimeWindow(Period period) {
        this.period = period;
    }

    @Override
    public WindowState newState(TopLevelExpression query) {
        return new MyWindowState(query);
    }

    public String toString() {
        return "over last " + this.period;
    }

    @Override
    public long estimateMultiplier(Period period) {
        return Math.max(this.period.estimateMillis() / period.estimateMillis(), 1L);
    }

    @Override
    public WindowInfo info(Period output) {
        return new OverLastInfo(this.period, output);
    }

    @Override
    public WindowInfo info(int amount) {
        return new OverLastInfo(this.period, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverLastTimeWindow)) {
            return false;
        }
        OverLastTimeWindow that = (OverLastTimeWindow)o;
        return Objects.equals(this.period, that.period);
    }

    public int hashCode() {
        return Objects.hash(this.period);
    }

    @Override
    public long estimateMultiplier(int amount) {
        return this.period.estimateMillis() / 10000L / (long)amount;
    }

    private class MyWindowState
    implements WindowState {
        private final LongQueue queue = new LongQueue();
        private final GroupingMerger merger;
        private final TopLevelExpression query;

        public MyWindowState(TopLevelExpression query) {
            this.query = query;
            this.merger = query.newMerger();
        }

        @Override
        public RowList yield(Long timestamp, long start, long end, GroupingTree rows) {
            long lowerBound = OverLastTimeWindow.this.period.sub(timestamp.longValue());
            this.queue.enqueue(timestamp);
            this.merger.push((Tree)rows);
            while (!this.queue.isEmpty() && this.queue.peek() <= lowerBound) {
                this.queue.dequeue();
                this.merger.pop();
            }
            return this.query.eval(null, (Tree)this.merger.get(), new WindowBoundsImpl(timestamp, lowerBound, timestamp, start, end, this.queue.size()));
        }
    }
}

