/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Literal;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingMerger;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.simple.OverLastQueue;
import net.intelie.pipes.simple.TimeWindow;
import net.intelie.pipes.simple.WindowState;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.types.OverSpanInfo;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.LongQueue;

public class OverSpanWindow
implements TimeWindow {
    public static final long BEST_DAY_TO_ESTIMATE_THINGS = 32503427999999L;
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final boolean fixed;

    public OverSpanWindow(TimeSpan span) {
        this.span = span;
        this.fixed = span.isFixed();
    }

    @Override
    public WindowState newState(TopLevelExpression query) {
        return new MyWindowState(query);
    }

    public String toString() {
        return "over span " + Literal.newString((Object)this.span);
    }

    @Override
    public long estimateMultiplier(Period period) {
        return this.fixed ? 1L : Math.max(Math.round((double)this.estimateMillis() / (double)period.forceZone(ZoneId.of("UTC")).estimateMillis()), 1L);
    }

    private long estimateMillis() {
        return 32503427999999L - this.span.forceZone(ZoneId.of("UTC")).start(32503427999999L);
    }

    @Override
    public WindowInfo info(Period output) {
        return new OverSpanInfo(this.span, output);
    }

    @Override
    public WindowInfo info(int amount) {
        return new OverSpanInfo(this.span);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverSpanWindow)) {
            return false;
        }
        OverSpanWindow that = (OverSpanWindow)o;
        return Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.span);
    }

    @Override
    public long estimateMultiplier(int amount) {
        return this.fixed ? 1L : this.estimateMillis() / 10000L / (long)amount;
    }

    private class MyWindowState
    implements WindowState {
        private final OverLastQueue future = new OverLastQueue();
        private final LongQueue current = new LongQueue();
        private final GroupingMerger merger;
        private final TopLevelExpression query;

        public MyWindowState(TopLevelExpression query) {
            this.query = query;
            this.merger = query.newMerger();
        }

        @Override
        public RowList yield(Long timestamp, long start, long end, GroupingTree rows) {
            long upperBound = OverSpanWindow.this.span.end(timestamp.longValue());
            long lowerBound = OverSpanWindow.this.span.start(timestamp.longValue());
            if (!OverSpanWindow.this.fixed) {
                this.future.enqueue(timestamp, rows);
                while (!this.future.isEmpty() && this.future.headKey() <= upperBound) {
                    long key = this.future.headKey();
                    GroupingTree toAdd = this.future.dequeue();
                    this.current.enqueue(key);
                    this.merger.push((Tree)toAdd);
                }
                while (!this.current.isEmpty() && this.current.peek() <= lowerBound) {
                    this.current.dequeue();
                    this.merger.pop();
                }
            } else if (timestamp > lowerBound && timestamp <= upperBound) {
                this.merger.push((Tree)rows);
            }
            return this.query.eval(null, (Tree)this.merger.get(), new WindowBoundsImpl(timestamp, lowerBound, upperBound, start, end, this.current.size()));
        }
    }
}

