/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.util.Set;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.simple.BatchAggregationPipe;
import net.intelie.pipes.simple.BatchWindow;
import net.intelie.pipes.simple.ItemAggregationPipe;
import net.intelie.pipes.simple.ItemWindow;
import net.intelie.pipes.simple.NoWindow;
import net.intelie.pipes.simple.TimePipe;
import net.intelie.pipes.simple.TimeWindow;
import net.intelie.pipes.simple.TotalPipe;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.ItemPipe;
import net.intelie.pipes.types.BatchOutput;
import net.intelie.pipes.types.ItemOutput;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.OutputType;
import net.intelie.pipes.types.TimeOutput;
import net.intelie.pipes.types.TotalOutput;
import net.intelie.pipes.types.Type;

public class SimplePipeFunction
implements Function {
    public static final String DEFAULT_PERIOD_ERROR = "Aggregation pipes should specify an output period (if that cannot be determined from the previous pipe). Since Pipes v0.16, whenever a time period cannot be determined from the previous pipe, it is mandatory to specify an output period.";
    private static final long serialVersionUID = 1L;

    public Pipe declare(ArgQueue queue) throws PipeException {
        CompilerContext config = queue.context();
        TopLevelExpression top = (TopLevelExpression)queue.aggregation((Type)Type.SEQ).get(TopLevelExpression.class);
        Window window = (Window)queue.getOptional(Window.class, new FallbackToConstant<NoWindow>(new NoWindow()));
        Output output = (Output)queue.getOptional(Output.class, q -> SimplePipeFunction.defaultOutput(config, top, window));
        top.validate(new ValidationContext(!(window instanceof NoWindow)));
        if (output instanceof ItemOutput) {
            return SimplePipeFunction.makeItemPipe(config, top, window, output);
        }
        if (output instanceof BatchOutput) {
            return SimplePipeFunction.makeBatchPipe(config, top, window, output);
        }
        if (output instanceof TotalOutput) {
            return SimplePipeFunction.makeTotalPipe(config, top, window, output);
        }
        if (output instanceof TimeOutput) {
            return SimplePipeFunction.makeTimePipe(config, top, window, output);
        }
        throw new PipeException("Unknown output type: [%s]", new Object[]{output});
    }

    private static Pipe makeTimePipe(CompilerContext config, TopLevelExpression top, Window window, Output output) throws PipeException {
        return new TimePipe(config, top, (TimeOutput)output, SimplePipeFunction.verifyWindow(output, window, TimeWindow.class));
    }

    private static Pipe makeTotalPipe(CompilerContext config, TopLevelExpression top, Window window, Output output) throws PipeException {
        SimplePipeFunction.verifyWindow(output, window, NoWindow.class);
        return new TotalPipe(config.metadata(), top);
    }

    private static Pipe makeBatchPipe(CompilerContext config, TopLevelExpression top, Window window, Output output) throws PipeException {
        return new BatchAggregationPipe(config, top, (BatchOutput)output, SimplePipeFunction.verifyWindow(output, window, BatchWindow.class));
    }

    private static Pipe makeItemPipe(CompilerContext config, TopLevelExpression top, Window window, Output output) throws PipeException {
        if (SimplePipeFunction.isSimpleScalar(top, window, output)) {
            return new ItemPipe(config, top);
        }
        return new ItemAggregationPipe(config, top, (ItemOutput)output, SimplePipeFunction.verifyWindow(output, window, ItemWindow.class));
    }

    private static <T extends Window> T verifyWindow(Output output, Window window, Class<T> clazz) throws PipeException {
        if (!clazz.isInstance(window)) {
            throw new PipeException("The output [%s] doesn't accept the window [%s].", new Object[]{output, window});
        }
        return (T)((Window)clazz.cast(window));
    }

    private static Output defaultOutput(CompilerContext config, TopLevelExpression top, Window window) throws PipeException {
        if (window instanceof NoWindow) {
            if (Level.SCALAR.accepts((Object)top)) {
                return new ItemOutput(1);
            }
            if (SimplePipeFunction.comesFromTotal(config.metadata())) {
                return new TotalOutput();
            }
        }
        if (window instanceof TimeWindow) {
            Set outputs = config.metadata().output();
            Output first = Iterables.getFirst(outputs, null);
            if (first == null || outputs.size() != 1 || first.type() != OutputType.TIMED) {
                throw new PipeException((Object)DEFAULT_PERIOD_ERROR);
            }
            return first;
        }
        if (window instanceof BatchWindow) {
            return new BatchOutput(1);
        }
        return new ItemOutput(1);
    }

    private static boolean isSimpleScalar(TopLevelExpression top, Window window, Output output) {
        return window instanceof NoWindow && Level.SCALAR.accepts((Object)top) && ((ItemOutput)output).isTransformationOnly();
    }

    private static boolean comesFromTotal(Metadata metadata) {
        Set outputs = metadata.output();
        Output first = Iterables.getFirst(outputs, null);
        return first != null && outputs.size() == 1 && first.type() == OutputType.TOTAL;
    }

    public String description() {
        return "<default>";
    }

    public String name() {
        return "@simple";
    }

    public HelpData help() {
        return null;
    }
}

