/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Sink;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.model.GroupingState;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.TotalOutput;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.WindowInfo;

public class TotalPipeMapper
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final TopLevelExpression query;
    private final Metadata metadata;

    public TotalPipeMapper(Metadata old, TopLevelExpression query) {
        this.query = query;
        this.metadata = old.withType((Type)Type.OBJECT).withSafe(true).withWeight(query.weight()).withWindow(WindowInfo.NONE).withOutput(new Output[]{new TotalOutput()});
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public boolean split() {
        return false;
    }

    public Pipe mapper() {
        return this;
    }

    public Pipe reducer() {
        return new EmptyPipe(this.metadata, new Window[0]);
    }

    public String toString() {
        return this.query + " at the end";
    }

    private class MyInstance
    extends BaseInstance {
        private final GroupingState state;
        private final Sink listener;

        public MyInstance(Sink listener) {
            this.state = TotalPipeMapper.this.query.newState(0);
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flow(Object obj) {
            MyInstance myInstance = this;
            synchronized (myInstance) {
                this.state.yield(null, obj);
            }
        }

        @Override
        public void destroy(boolean flushTimers) {
            this.listener.onRaw((RawEvent)ArrayRawEvent.fromArray((Object[])new Object[]{this.state.flip()}));
        }

        @Override
        public void destroy() {
            this.destroy(true);
        }
    }
}

