/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.simple;

import java.time.ZoneId;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.simple.OverAllWindow;
import net.intelie.pipes.simple.OverCurrentCountWindow;
import net.intelie.pipes.simple.OverCurrentTimeWindow;
import net.intelie.pipes.simple.OverLastCountWindow;
import net.intelie.pipes.simple.OverLastTimeWindow;
import net.intelie.pipes.simple.OverSpanWindow;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodSpan;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanParser;
import net.intelie.pipes.types.Type;

public class WindowFunction
implements Function {
    private static final long serialVersionUID = 1L;

    public Object declare(ArgQueue queue) throws PipeException {
        String kind = (String)queue.constantValue((Type)Type.STRING).get();
        if ("all".equalsIgnoreCase(kind)) {
            return new OverAllWindow();
        }
        if ("span".equalsIgnoreCase(kind)) {
            ZoneId zone;
            String spanText = (String)queue.constantValue((Type)Type.STRING).get();
            TimeSpan span = new TimeSpanParser().parse(spanText, zone = this.getZone(queue));
            if (span instanceof PeriodSpan && ((PeriodSpan)span).span() == null) {
                return new OverCurrentTimeWindow(((PeriodSpan)span).period());
            }
            return new OverSpanWindow(span);
        }
        boolean isLast = this.getIsLast(kind);
        Period period = (Period)queue.constantValue((Type)Type.PERIOD).getSafe();
        if (period != null) {
            return this.timeWindow(isLast, period);
        }
        String unit = (String)queue.constantValue((Type)Type.STRING).get();
        int amount = ((Double)queue.constantValue((Type)Type.NUMBER).getSafe(new FallbackToConstant<Double>(1.0))).intValue();
        if (this.isUnit(unit, "item", "items")) {
            return this.itemWindow(isLast, amount);
        }
        if (this.isUnit(unit, "batch", "batchs", "batches")) {
            return this.batchWindow(isLast, amount);
        }
        return this.timeWindow(isLast, (Period)new SimplePeriod(amount, unit, this.getZone(queue)));
    }

    private Object batchWindow(boolean isLast, int amount) {
        if (isLast) {
            return new OverLastCountWindow.Batch(amount);
        }
        return new OverCurrentCountWindow.Batch(amount);
    }

    private Object itemWindow(boolean isLast, int amount) {
        if (isLast) {
            return new OverLastCountWindow.Item(amount);
        }
        return new OverCurrentCountWindow.Item(amount);
    }

    private Object timeWindow(boolean isLast, Period period) throws PipeException {
        if (isLast) {
            return new OverLastTimeWindow(period);
        }
        return new OverCurrentTimeWindow(period);
    }

    private boolean getIsLast(String kind) throws PipeException {
        boolean moving;
        if ("last".equalsIgnoreCase(kind)) {
            moving = true;
        } else if ("current".equalsIgnoreCase(kind)) {
            moving = false;
        } else {
            throw new PipeException("Unknown window kind: %s", new Object[]{kind});
        }
        return moving;
    }

    private ZoneId getZone(ArgQueue queue) throws PipeException {
        String zoneText = (String)queue.constantValue((Type)Type.STRING).getOptional();
        if (zoneText == null) {
            return ZoneId.systemDefault();
        }
        return ZoneId.of(zoneText);
    }

    private boolean isUnit(String unit, String ... expected) {
        for (String s : expected) {
            if (!s.equalsIgnoreCase(unit)) continue;
            return true;
        }
        return false;
    }

    public String description() {
        return "<window>";
    }

    public String name() {
        return ".window";
    }

    public HelpData help() {
        return null;
    }
}

