/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.types.Metadata;

@Export(value={"@atomic"})
@Help(key="pipe-atomic", omit=true)
public class AtomicPipe
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final Pipe pipe;
    private final Metadata metadata;

    public AtomicPipe(ArgQueue queue) throws PipeException {
        Metadata originalMetadata = queue.context().metadata();
        CompilerContext newContext = queue.context().newSource(originalMetadata.withSafe(true));
        this.pipe = (Pipe)queue.withContext(newContext).get(Pipe.class);
        Metadata old = this.pipe.metadata();
        this.metadata = queue.metadata().withType(old.type()).withSafe(originalMetadata.safe()).withWeight(old.weight()).withWindow(old.window()).withOutput((Iterable)old.output());
    }

    public boolean split() {
        return false;
    }

    public Pipe mapper() {
        return this.pipe.mapper();
    }

    public Pipe reducer() {
        return this.pipe.reducer();
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public PipeInstance newInstance(Sink listener) {
        return this.pipe.newInstance(listener);
    }

    public String toString() {
        return "atomic [" + this.pipe + "]";
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.pipe.visit(parent, visitor);
    }
}

