/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.pip.Distance;
import net.intelie.pipes.util.pip.MultiPip;
import net.intelie.pipes.util.pip.Pip;
import net.intelie.pipes.util.pip.PipPoint;

@Export(value={"@compress.pip"})
@Help(key="pipe-compress-pip")
public class CompressPipPipe
implements Pipe {
    public static final int MAX_UNNAMED_PROPS = 128;
    private static final long serialVersionUID = 1L;
    private static final Distance<PipPoint<Object>> DISTANCE = PipPoint.distance();
    private final Metadata metadata;
    private final int localPoints;
    private final Double globalPoints;
    private final Scalar<Double>[] expr;
    private final GroupBy group;
    private final Property<Double> timestamp;
    private final RowFields fields;
    private final Scalar<Iterable> expr2;

    public CompressPipPipe(ArgQueue queue) throws PipeException {
        queue.ensureSafe();
        this.group = queue.groupBy().ensureNoExpiry();
        this.localPoints = ((Double)queue.constantValue((Type)Type.NUMBER).getSafe(new FallbackToConstant<Double>(100.0))).intValue();
        this.globalPoints = (Double)queue.constantValue((Type)Type.NUMBER).getSafe();
        PipeException.check((this.localPoints >= 1 ? 1 : 0) != 0, (Object)"Local points must be positive");
        PipeException.check((this.globalPoints == null || this.globalPoints >= 1.0 ? 1 : 0) != 0, (Object)"Global points must be positive");
        this.expr2 = (Scalar)queue.scalar((Type)new SeqType((Type)Type.NUMBER)).getSafe();
        this.expr = (Scalar[])queue.scalar((Type)Type.NUMBER).array();
        if (this.expr.length == 0 && this.expr2 == null) {
            throw new PipeException((Object)"Must have at least one expression");
        }
        this.timestamp = queue.context().timestamp();
        Metadata old = queue.context().metadata();
        this.metadata = old.withWeight((long)CompressPipPipe.decideWeight(old, this.localPoints, this.globalPoints, this.group));
        this.fields = this.metadata.getRowFields();
    }

    private static int decideWeight(Metadata metadata, int points, Double globalPoints, GroupBy group) {
        int groupsSize;
        RowFields fields = metadata.getRowFields();
        int eventSize = fields == null ? 1 : fields.size() + 1;
        int n = groupsSize = group.size() == 0 ? 1 : 64;
        if (globalPoints == null) {
            return points * eventSize * 32 * groupsSize;
        }
        return globalPoints.intValue() * eventSize * 32 + 8 * groupsSize;
    }

    public boolean split() {
        return true;
    }

    public Pipe mapper() {
        return new EmptyPipe(this.metadata, new Window[0]);
    }

    public Pipe reducer() {
        return this;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    public String toString() {
        String s = "@compress.pip " + this.localPoints + ", ";
        if (this.globalPoints != null) {
            s = s + this.globalPoints.intValue() + ", ";
        }
        if (this.expr2 != null) {
            s = s + this.expr2 + (this.expr.length > 0 ? ", " : "");
        }
        s = s + Iterables.join((String)", ", (Object[])this.expr);
        if (!this.group.isEmpty()) {
            s = s + " " + this.group;
        }
        return s;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.timestamp.visit(parent, visitor);
        this.group.visit(parent, visitor);
        for (Scalar<Double> item : this.expr) {
            item.visit(parent, visitor);
        }
        if (this.expr2 != null) {
            this.expr2.visit(parent, visitor);
        }
        return visitor;
    }

    static /* synthetic */ Distance access$000() {
        return DISTANCE;
    }

    static /* synthetic */ GroupBy access$100(CompressPipPipe x0) {
        return x0.group;
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private final MultiPip<PipPoint<Object>> master = new MultiPip(CompressPipPipe.access$000());
        private final GroupBy.State<Pip<PipPoint<Object>>[]> state = CompressPipPipe.access$100(CompressPipPipe.this).newState(key -> this.requireSlots(CompressPipPipe.this.expr.length + (CompressPipPipe.this.expr2 != null ? 128 : 0)));
        private double minX = Double.NEGATIVE_INFINITY;

        public MyInstance(Sink listener) {
            this.listener = listener;
        }

        private Pip<PipPoint<Object>>[] requireSlots(int length) {
            Pip[] arr = new Pip[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = this.master.requireSlot();
            }
            return arr;
        }

        @Override
        public synchronized void flow(Object obj) {
            Iterable it;
            Double x = this.extractX(obj);
            if (!this.validateX(x)) {
                return;
            }
            Pip[] heap = (Pip[])this.state.get(null, obj);
            for (int i = 0; i < CompressPipPipe.this.expr.length; ++i) {
                Double value = (Double)CompressPipPipe.this.expr[i].eval(null, obj);
                if (value == null) continue;
                heap[i].offer(new PipPoint<Object>(obj, x, value));
            }
            if (CompressPipPipe.this.expr2 != null && (it = (Iterable)CompressPipPipe.this.expr2.eval(null, obj)) != null) {
                int i = CompressPipPipe.this.expr.length;
                int len = heap.length;
                for (Object o : it) {
                    if (o instanceof Double) {
                        heap[i].offer(new PipPoint<Object>(obj, x, (Double)o));
                    }
                    if (++i < len) continue;
                    break;
                }
            }
            this.ensureCompression(heap);
        }

        private void ensureCompression(Pip<PipPoint<Object>>[] heaps) {
            for (Pip<PipPoint<Object>> heap : heaps) {
                while (heap.size() > CompressPipPipe.this.localPoints) {
                    heap.removeMin();
                }
            }
            if (CompressPipPipe.this.globalPoints != null) {
                while ((double)this.master.size() > CompressPipPipe.this.globalPoints) {
                    this.master.removeMin();
                }
            }
        }

        private Double extractX(Object obj) {
            return (Double)CompressPipPipe.this.timestamp.eval(null, obj);
        }

        private boolean validateX(Double x) {
            if (x == null) {
                return false;
            }
            if (x < this.minX) {
                return false;
            }
            this.minX = x;
            return true;
        }

        @Override
        public void destroy(boolean flushTimers) {
            if (CompressPipPipe.this.fields == null) {
                this.listener.onRaw((RawEvent)new ArrayRawEvent(this.extractResult(Object.class)));
            } else {
                this.listener.onEvent(CompressPipPipe.this.fields, (RowList)new ArrayRowList(this.extractResult(Row.class)));
            }
        }

        private <T> List<T> extractResult(Class<T> clazz) {
            LinkedHashSet<T> list = new LinkedHashSet<T>();
            for (Object o : PipPoint.unpack(this.master)) {
                if (!clazz.isInstance(o)) continue;
                list.add(clazz.cast(o));
            }
            return new ArrayList(list);
        }
    }
}

