/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Throttler;

@Export(value={"@debounce"})
@Help(key="pipe-debounce")
public class DebouncePipe
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final Metadata metadata;
    private final Period period;
    private final GroupBy group;
    private final Property<Double> timestamp;
    private final RowFields fields;

    public DebouncePipe(ArgQueue queue) throws PipeException {
        this.group = queue.groupBy().ensureNoExpiry();
        this.period = (Period)queue.constantValue((Type)Type.PERIOD).get();
        this.timestamp = queue.context().timestamp();
        Metadata old = queue.context().metadata();
        this.metadata = old.withSafe(true).withWeight((long)this.decideWeight(this.group));
        this.fields = this.metadata.getRowFields();
    }

    private int decideWeight(GroupBy group) {
        return (8 + (group.size() + 1) * 32) * (group.size() == 0 ? 1 : 64);
    }

    public boolean split() {
        return true;
    }

    public Pipe mapper() {
        return this;
    }

    public Pipe reducer() {
        return this;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    public String toString() {
        String s = "@debounce " + this.period;
        if (this.group.size() > 0) {
            s = s + " " + this.group;
        }
        return s;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.timestamp.visit(parent, visitor);
        this.group.visit(parent, visitor);
        return visitor;
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private final Throttler throttler;
        private final UnsafeRow buffer;

        public MyInstance(Sink listener) {
            this.listener = listener;
            this.buffer = new UnsafeRow(DebouncePipe.this.group.size());
            this.throttler = new Throttler(1, DebouncePipe.this.period);
        }

        private boolean offer(Object obj) {
            Double x = (Double)DebouncePipe.this.timestamp.eval(null, obj);
            if (x == null) {
                return false;
            }
            DebouncePipe.this.group.evalUnsafe(null, obj, this.buffer);
            return this.throttler.replace(this.buffer, x.longValue());
        }

        @Override
        public void flowMany(Iterable iterable) {
            if (DebouncePipe.this.fields != null) {
                List<Row> rows = this.extract(iterable, Row.class);
                if (rows.size() > 0) {
                    this.listener.onEvent(DebouncePipe.this.fields, (RowList)new ArrayRowList(rows));
                }
            } else {
                List<Object> rows = this.extract(iterable, Object.class);
                if (rows.size() > 0) {
                    this.listener.onRaw((RawEvent)new ArrayRawEvent(rows));
                }
            }
        }

        private synchronized <T> List<T> extract(Iterable iterable, Class<T> clazz) {
            ArrayList<T> rows = new ArrayList<T>();
            for (Object o : iterable) {
                if (!clazz.isInstance(o) || !this.offer(o)) continue;
                rows.add(clazz.cast(o));
            }
            return rows;
        }
    }
}

