/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.State;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.Type;

@Export(value={"@filter"})
@Help(key="pipe-filter")
public class FilterStatefulPipe
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final Aggregation<Boolean> expr;
    private final Metadata metadata;
    private final RowFields fields;
    private final GroupBy group;

    public FilterStatefulPipe(ArgQueue queue) throws PipeException {
        queue.ensureSafe();
        this.group = queue.groupBy().ensureExpiry();
        this.expr = (Aggregation)queue.aggregation((Type)Type.BOOLEAN).get();
        this.metadata = queue.context().metadata().resetWeights(this.expr.weight() * (long)(this.group.isEmpty() ? 1 : 64));
        this.fields = this.metadata.getRowFields();
        PipeException.check((!this.expr.level().isAssignableTo((Level)Level.SCALAR) ? 1 : 0) != 0, (Object)"This version of @filter pipe cannot be used with scalars, only aggregations.");
    }

    public boolean split() {
        return true;
    }

    public Pipe mapper() {
        return this;
    }

    public Pipe reducer() {
        return new EmptyPipe(this.metadata(), new Window[0]);
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public String toString() {
        return "@filter " + this.expr + (this.group.isEmpty() ? "" : " " + this.group);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.group.visit(parent, visitor);
        this.expr.visit(parent, visitor);
        return visitor;
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private final GroupBy.State<State> state;

        public MyInstance(Sink listener) {
            this.state = FilterStatefulPipe.this.group.newState(key -> FilterStatefulPipe.this.expr.newState(0));
            this.listener = listener;
        }

        @Override
        public void flowMany(Iterable iterable) {
            if (FilterStatefulPipe.this.fields != null) {
                List<Row> rows = this.extract(iterable, Row.class);
                if (rows.size() > 0) {
                    this.listener.onEvent(FilterStatefulPipe.this.fields, (RowList)new ArrayRowList(rows));
                }
            } else {
                List<Object> rows = this.extract(iterable, Object.class);
                if (rows.size() > 0) {
                    this.listener.onRaw((RawEvent)new ArrayRawEvent(rows));
                }
            }
        }

        private <T> List<T> extract(Iterable iterable, Class<T> clazz) {
            ArrayList<T> rows = new ArrayList<T>();
            for (Object o : iterable) {
                State thisState = (State)this.state.get(null, o);
                thisState.yield(null, o);
                if (!clazz.isInstance(o) || !Boolean.TRUE.equals(FilterStatefulPipe.this.expr.eval(null, thisState.flip(), null))) continue;
                rows.add(clazz.cast(o));
            }
            return rows;
        }
    }
}

