/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import net.intelie.pipes.FullPipe;
import net.intelie.pipes.FullPipeInstance;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.PipeInstanceValve;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.Valve;
import net.intelie.pipes.filters.FastFilterTester;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.time.SchedulerContext;
import net.intelie.pipes.types.Metadata;

public class FullPipeImpl
implements FullPipe {
    private static final long serialVersionUID = 1L;
    private final Filter filter;
    private final Pipe pipe;
    private final Metadata oldMeta;

    public FullPipeImpl(Metadata oldMeta, Filter filter, Pipe pipe) {
        if (pipe == null) {
            pipe = new EmptyPipe(oldMeta, new Window[0]);
        }
        this.oldMeta = oldMeta;
        this.filter = filter;
        this.pipe = pipe;
    }

    public static String makeString(Filter filter, Pipe pipe) {
        String pipeStr = "" + pipe;
        return filter + (pipeStr.isEmpty() ? "" : " => " + pipeStr);
    }

    public Filter filter() {
        return this.filter;
    }

    public Pipe unfiltered() {
        return this.pipe;
    }

    public boolean split() {
        return this.pipe.split();
    }

    public FullPipeImpl replaceFilter(Filter filter) {
        return new FullPipeImpl(this.oldMeta, filter, this.pipe);
    }

    public FullPipe mapper() {
        return new FullPipeImpl(this.oldMeta, this.filter, this.pipe.mapper());
    }

    public Pipe reducer() {
        return this.pipe.reducer();
    }

    public String toString() {
        return FullPipeImpl.makeString(this.filter, this.pipe);
    }

    public Metadata metadata() {
        return this.pipe.metadata();
    }

    private FullPipeInstance wrapFilter(PipeInstance instance) {
        return new MyInstance(this.filter, instance);
    }

    public FullPipeInstance newInstance(Sink listener) {
        return this.wrapFilter(this.pipe.newInstance(listener));
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.filter.visit(parent, visitor);
        return this.pipe.visit(parent, visitor);
    }

    public class MyInstance
    extends BaseInstance
    implements FullPipeInstance {
        private final FastFilterTester tester;
        private final PipeInstance inner;
        private final PipeInstanceValve valve;

        public MyInstance(Filter filter, PipeInstance inner) {
            this.tester = new FastFilterTester(filter);
            this.inner = inner;
            this.valve = new PipeInstanceValve(filter, FullPipeImpl.this.pipe, inner);
        }

        @Override
        public void flow(Object obj) {
            if (this.accepts(obj)) {
                this.inner.flow(obj);
            }
        }

        @Override
        public void flowMany(Iterable iterable) {
            ArrayList list = new ArrayList();
            for (Object obj : iterable) {
                if (!this.accepts(obj)) continue;
                list.add(obj);
            }
            this.inner.flowMany(list);
        }

        public synchronized boolean accepts(Object obj) {
            return this.tester.accepts(obj);
        }

        public PipeInstance unfilteredInstance() {
            return this.inner;
        }

        public Valve asValve() {
            return this.valve;
        }

        @Override
        public void destroy(boolean flushTimers) {
            this.inner.destroy(flushTimers);
        }

        @Override
        public void turnOn(SchedulerContext context) {
            this.inner.turnOn(context);
        }

        @Override
        public void advanceTo(long timestamp) {
            this.inner.advanceTo(timestamp);
        }
    }
}

