/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Sink;
import net.intelie.pipes.guava.collect.Lists;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;

@Export(value={"@latest"})
@Help(key="pipe-latest")
public class LatestPipe
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final Metadata metadata;
    private final RowFields fields;

    public LatestPipe(ArgQueue queue) throws PipeException {
        queue.ensureSafe();
        this.metadata = queue.context().metadata();
        this.fields = this.metadata.getRowFields();
    }

    public boolean split() {
        return true;
    }

    public Pipe mapper() {
        return new EmptyPipe(this.metadata, new Window[0]);
    }

    public Pipe reducer() {
        return this;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    public String toString() {
        return "@latest";
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private volatile Iterable latest;

        public MyInstance(Sink listener) {
            this.listener = listener;
        }

        @Override
        public void flow(Object obj) {
            this.latest = Lists.newArrayList(obj);
        }

        @Override
        public void flowMany(Iterable iterable) {
            this.latest = iterable;
        }

        @Override
        public void destroy(boolean flushTimers) {
            if (LatestPipe.this.fields == null) {
                this.listener.onRaw((RawEvent)new ArrayRawEvent(this.extract(Object.class)));
            } else {
                this.listener.onEvent(LatestPipe.this.fields, (RowList)new ArrayRowList(this.extract(Row.class)));
            }
        }

        private <T> List<T> extract(Class<T> clazz) {
            ArrayList<T> list = new ArrayList<T>();
            if (this.latest != null) {
                for (Object o : this.latest) {
                    if (!clazz.isInstance(o)) continue;
                    list.add(clazz.cast(o));
                }
            }
            return list;
        }
    }
}

