/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.model.NamedExpressionImpl;
import net.intelie.pipes.model.SelectClauseImpl;
import net.intelie.pipes.modules.FallbackToNamed;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.Type;

@Export(value={"@onchange"})
@Help(key="pipe-onchange")
public class OnChangePipe
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final Metadata metadata;
    private final Scalar expr;
    private final GroupBy group;
    private final RowFields fields;

    public OnChangePipe(ArgQueue queue) throws PipeException {
        queue.ensureSafe();
        this.group = queue.groupBy().ensureExpiry();
        this.expr = this.makeScalar(queue);
        Metadata old = queue.context().metadata();
        this.metadata = old.withSafe(true).resetWeights((long)this.decideWeight(this.group));
        this.fields = this.metadata.getRowFields();
    }

    private int decideWeight(GroupBy group) {
        return (8 + (group.size() + 1) * 32) * (group.size() == 0 ? 1 : 64);
    }

    public boolean split() {
        return true;
    }

    public Pipe mapper() {
        return new EmptyPipe(this.metadata, new Window[0]);
    }

    public Pipe reducer() {
        return this;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.group.visit(parent, visitor);
        this.expr.visit(parent, visitor);
        return visitor;
    }

    public String toString() {
        String s = this.pipeName() + " " + this.expr;
        if (this.group.size() > 0) {
            s = s + " " + this.group;
        }
        return s;
    }

    public String pipeName() {
        return "@onchange";
    }

    public boolean validateValue(Object value) {
        return true;
    }

    public Scalar makeScalar(ArgQueue queue) throws PipeException {
        NamedExpression[] array = (NamedExpression[])queue.scalar((Type)Type.OBJECT).arraySafe(NamedExpression.class, (Fallback)new FallbackToNamed((Level)Level.SCALAR));
        if (array.length == 0) {
            array = new NamedExpression[]{new NamedExpressionImpl((Expression)queue.compiler().expression().compileToQueue(new String[]{"_"}).scalar((Type)Type.OBJECT).get())};
        }
        return new SelectClauseImpl(array);
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private final GroupBy.State<Slot> state;

        public MyInstance(Sink listener) {
            this.listener = listener;
            this.state = OnChangePipe.this.group.newState(key -> new Slot());
        }

        @Override
        public void flowMany(Iterable iterable) {
            if (OnChangePipe.this.fields != null) {
                List<Row> rows = this.extract(iterable, Row.class);
                if (rows.size() > 0) {
                    this.listener.onEvent(OnChangePipe.this.fields, (RowList)new ArrayRowList(rows));
                }
            } else {
                List<Object> rows = this.extract(iterable, Object.class);
                if (rows.size() > 0) {
                    this.listener.onRaw((RawEvent)new ArrayRawEvent(rows));
                }
            }
        }

        private boolean offer(Object obj) {
            Object x = OnChangePipe.this.expr.eval(null, obj);
            Slot old = (Slot)this.state.get(null, obj);
            if (old.init && Objects.equals(old.last, x)) {
                return false;
            }
            old.init = true;
            old.last = x;
            return OnChangePipe.this.validateValue(x);
        }

        private <T> List<T> extract(Iterable iterable, Class<T> clazz) {
            ArrayList<T> rows = new ArrayList<T>();
            for (Object o : iterable) {
                if (!clazz.isInstance(o) || !this.offer(o)) continue;
                rows.add(clazz.cast(o));
            }
            return rows;
        }
    }

    private static class Slot {
        private boolean init = false;
        private Object last = null;

        private Slot() {
        }
    }
}

