/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.PropertyReplacer;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectState;
import net.intelie.pipes.Sink;
import net.intelie.pipes.Tree;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.model.SelectClauseImpl;
import net.intelie.pipes.modules.FallbackToNamed;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.SetPipePropertyVisitor;

@Export(value={"@set"})
@Help(key="pipe-set")
public class SetStatefulPipe
implements Pipe {
    private static final long serialVersionUID = 1L;
    private final SelectClauseImpl select;
    private final RowFields fakeFields;
    private final PropertyReplacer config;
    private final RowFields fields;
    private final Metadata metadata;
    private final GroupBy group;

    public SetStatefulPipe(ArgQueue queue) throws PipeException {
        queue.ensureSafe();
        this.group = queue.groupBy().ensureExpiry();
        this.select = new SelectClauseImpl((NamedExpression[])queue.aggregation((Type)Type.OBJECT).arraySafe(NamedExpression.class, (Fallback)new FallbackToNamed((Level)Level.AGGREGATION)));
        PipeException.check((!this.select.level().isAssignableTo((Level)Level.SCALAR) ? 1 : 0) != 0, (Object)"This version of @set pipe cannot be used with scalars, only aggregations.");
        this.fakeFields = new RowFields(new ClauseInfo(new FieldInfo[0]), new ClauseInfo(new FieldInfo[0]), this.select.info());
        this.config = queue.context().makeReplacer();
        Metadata old = queue.context().metadata();
        RowFields oldFields = old.getRowFields();
        if (oldFields == null) {
            this.fields = null;
            this.metadata = old.resetWeights(this.select.weight() + 8L);
        } else {
            this.fields = new RowFields(oldFields.timestamp(), oldFields.group(), new ClauseInfo(Iterables.concat(oldFields.select(), this.select.info())));
            this.metadata = old.withType((Type)new RowType(this.fields)).resetWeights((this.select.weight() + 8L) * (long)(this.group.isEmpty() ? 1 : 64));
        }
    }

    public boolean split() {
        return true;
    }

    public Pipe mapper() {
        return this;
    }

    public Pipe reducer() {
        return new EmptyPipe(this.metadata(), new Window[0]);
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public String toString() {
        return "@set " + this.select + (this.group.isEmpty() ? "" : " " + this.group);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.group.visit(parent, visitor);
        this.select.visit(parent, visitor);
        return new SetPipePropertyVisitor(visitor, (Iterable<FieldInfo>)this.select.info());
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private final GroupBy.State<SelectState> state;

        public MyInstance(Sink listener) {
            this.listener = listener;
            this.state = SetStatefulPipe.this.group.newState(key -> SetStatefulPipe.this.select.newState(0));
        }

        @Override
        public void flowMany(Iterable iterable) {
            if (SetStatefulPipe.this.fields != null) {
                List<Row> rows = this.extract(iterable, Row.class);
                if (rows.size() > 0) {
                    this.listener.onEvent(SetStatefulPipe.this.fields, (RowList)new ArrayRowList(rows));
                }
            } else {
                List<Object> rows = this.extract(iterable, Object.class);
                if (rows.size() > 0) {
                    this.listener.onRaw((RawEvent)new ArrayRawEvent(rows));
                }
            }
        }

        private <T> List<T> extract(Iterable iterable, Class<T> clazz) {
            ArrayList<T> rows = new ArrayList<T>();
            for (Object o : iterable) {
                SelectState thisState = (SelectState)this.state.get(null, o);
                thisState.yield(null, o);
                Object no = SetStatefulPipe.this.config.replaceValues(o, SetStatefulPipe.this.fakeFields, (Row)SetStatefulPipe.this.select.eval(null, (Tree)thisState.flip(), null));
                if (!clazz.isInstance(no)) continue;
                rows.add(clazz.cast(no));
            }
            return rows;
        }
    }
}

