/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.HashSet;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.guava.collect.Sets;
import net.intelie.pipes.stateful.fork.ForkOutput;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.OutputType;

public abstract class CombiningOutput
implements ForkOutput {
    private final Metadata metadata;
    private final OutputType outputType;

    protected CombiningOutput(Metadata metadata) throws PipeException {
        this.metadata = metadata;
        this.outputType = this.decideOutput(metadata);
    }

    private OutputType decideOutput(Metadata metadata) throws PipeException {
        HashSet<OutputType> types = Sets.newHashSet();
        for (Output output : metadata.output()) {
            types.add(output.type());
        }
        if (types.size() != 1) {
            throw new PipeException("Must have one (and only one) output type. All types: %s", new Object[]{types});
        }
        return Iterables.getFirst(types, null);
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public OutputType restrictedOutput() {
        return this.outputType;
    }
}

