/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.Arrays;
import java.util.function.UnaryOperator;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;

public class CombiningPropertyVisitor
implements PropertyVisitor {
    private final PropertyVisitor[] visitors;

    public CombiningPropertyVisitor(PropertyVisitor ... visitors) {
        this.visitors = visitors;
    }

    public PropertyVisitor property(Property<?> property) {
        return this.apply(v -> v.property(property));
    }

    public PropertyVisitor anyProperty() {
        return this.apply(PropertyVisitor::anyProperty);
    }

    public PropertyVisitor unknown(Object obj) {
        return this.apply(v -> v.unknown(obj));
    }

    public PropertyVisitor newScope() {
        return this.apply(PropertyVisitor::newScope);
    }

    public PropertyVisitor newChildScope() {
        return this.apply(PropertyVisitor::newChildScope);
    }

    private CombiningPropertyVisitor apply(UnaryOperator<PropertyVisitor> function) {
        return new CombiningPropertyVisitor((PropertyVisitor[])Arrays.stream(this.visitors).map(function).toArray(PropertyVisitor[]::new));
    }
}

