/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.ArrayList;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Sink;
import net.intelie.pipes.stateful.fork.ForkOutput;
import net.intelie.pipes.stateful.fork.ForkRawEvent;
import net.intelie.pipes.types.CompositeInfo;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.OutputType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.WindowInfo;

public class DelayedOutput
implements ForkOutput {
    private static final long serialVersionUID = 1L;
    private final Metadata metadata;

    public DelayedOutput(Metadata meta, Pipe[] pipes) {
        this.metadata = this.calculateMeta(meta, pipes);
    }

    private Metadata calculateMeta(Metadata old, Pipe[] pipes) {
        long weight = 0L;
        ArrayList outputs = new ArrayList();
        ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
        for (Pipe pipe : pipes) {
            Metadata meta = pipe.metadata();
            weight += meta.weight();
            outputs.addAll(meta.output());
            windows.add(meta.window());
        }
        return old.withType((Type)Type.OBJECT).withSafe(false).withWeight(weight).withWindow((WindowInfo)new CompositeInfo(windows)).withOutput(outputs);
    }

    @Override
    public void flush(Sink sink, Long time, Iterable ... events) {
        sink.onRaw((RawEvent)new ForkRawEvent(time, events));
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public OutputType restrictedOutput() {
        return null;
    }
}

