/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.guava.collect.Iterators;
import net.intelie.pipes.util.Iterables;

public class ForkRawEvent
implements RawEvent {
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final Iterable[] events;

    public ForkRawEvent(Long timestamp, Iterable ... events) {
        this.timestamp = timestamp;
        this.events = events;
    }

    public void flowAt(PipeInstance ... instances) {
        for (int i = 0; i < Math.min(this.events.length, instances.length); ++i) {
            instances[i].flowMany(this.events[i]);
        }
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public int size() {
        return this.events.length;
    }

    public Object get(int i) {
        if (i < 0 || i >= this.events.length) {
            return null;
        }
        return this.events[i];
    }

    public Iterator<Object> iterator() {
        return Iterators.forArray((Object[])this.events);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ForkRawEvent)) {
            return false;
        }
        ForkRawEvent objects = (ForkRawEvent)o;
        return Arrays.equals(this.events, objects.events) && Objects.equals(this.timestamp, objects.timestamp);
    }

    public int hashCode() {
        return Arrays.hashCode(this.events) * 31 + Objects.hash(this.timestamp);
    }

    public String toString() {
        return this.timestamp + "\n" + Iterables.join((String)"\n", (Object[])this.events);
    }
}

