/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Expression;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.Sink;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.PropertyNode;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.guava.collect.Sets;
import net.intelie.pipes.guava.collect.Streams;
import net.intelie.pipes.model.NamedExpressionImpl;
import net.intelie.pipes.model.SelectClauseImpl;
import net.intelie.pipes.stateful.fork.CombiningOutput;
import net.intelie.pipes.stateful.fork.CombiningPropertyVisitor;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.CompositeInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.Preconditions;

public class JoinOutput
extends CombiningOutput {
    private static final long serialVersionUID = 1L;
    private static final ArrayRowList EMPTY = new ArrayRowList(new Row[0]);
    private final Pipe[] pipes;
    private final SelectClause[] joinOn;
    private final RowFields[] innerFields;
    private final int[][] positions;
    private final int size;
    private final boolean left;
    private final boolean right;
    private final RowFields fields;

    public JoinOutput(CompilerContext src, boolean left, boolean right, String[] joinOnFields, Pipe ... pipes) throws PipeException {
        super(JoinOutput.decideMetadata(src.metadata(), pipes, joinOnFields));
        this.pipes = pipes;
        this.left = left;
        this.right = right;
        this.joinOn = new SelectClause[pipes.length];
        this.innerFields = new RowFields[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            Metadata metadata = pipes[i].metadata();
            this.innerFields[i] = metadata.getRowFields();
            this.joinOn[i] = JoinOutput.makeSelect(src, joinOnFields, metadata);
            if (this.joinOn[i].info().equals((Object)this.joinOn[0].info())) continue;
            throw new PipeException("Incompatible join field lists: (%s) != (%s)", new Object[]{this.joinOn[i].info(), this.joinOn[0].info()});
        }
        this.positions = new int[pipes.length][];
        this.size = this.fillPositions(pipes, joinOnFields);
        this.fields = this.metadata().getRowFields();
    }

    private static Metadata decideMetadata(Metadata old, Pipe[] pipes, String[] joinOn) throws PipeException {
        Metadata firstMeta = pipes[0].metadata();
        for (Pipe pipe : pipes) {
            Metadata meta = pipe.metadata();
            if (!meta.hasRowFields()) {
                throw new PipeException("Raw-typed pipes aren't allowed: '%s'", new Object[]{pipe});
            }
            if (firstMeta.isOutputCompatibleWith(meta)) continue;
            throw new PipeException("When joining pipes, output must match: '%s' not compatible with '%s'", new Object[]{firstMeta.output(), meta.output()});
        }
        HashSet<String> already = Sets.newHashSet();
        HashSet<String> joinOnSet = Sets.newHashSet(joinOn);
        ArrayList groups = new ArrayList();
        ArrayList selects = new ArrayList();
        ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
        long weight = 0L;
        boolean safe = false;
        for (Pipe pipe : pipes) {
            Metadata thisMeta = pipe.metadata();
            RowFields fields = thisMeta.getRowFields();
            List<FieldInfo> localGroups = JoinOutput.prepareNames(already, joinOnSet, fields.group());
            List<FieldInfo> localSelect = JoinOutput.prepareNames(already, joinOnSet, fields.select());
            JoinOutput.addAlreadySet(already, localGroups);
            JoinOutput.addAlreadySet(already, localSelect);
            Iterables.addAll(groups, localGroups);
            Iterables.addAll(selects, localSelect);
            windows.add(thisMeta.window());
            weight += thisMeta.weight();
            safe |= thisMeta.safe();
        }
        return old.withType((Type)new RowType(new RowFields(firstMeta.getRowFields().timestamp(), new ClauseInfo(groups), new ClauseInfo(selects)))).withSafe(safe).withWeight(weight).withWindow((WindowInfo)new CompositeInfo(windows)).withOutput((Iterable)firstMeta.output());
    }

    private static void addAlreadySet(Set<String> already, List<FieldInfo> groups) {
        for (FieldInfo info : groups) {
            already.add(info.name());
        }
    }

    private static List<FieldInfo> prepareNames(Set<String> already, Set<String> joinOn, ClauseInfo metaClause) {
        ArrayList<FieldInfo> localGroups = new ArrayList<FieldInfo>();
        block0: for (FieldInfo info : metaClause) {
            if (!already.contains(info.name())) {
                localGroups.add(info);
                continue;
            }
            if (joinOn.contains(info.name())) continue;
            for (int i = 2; i < 10000; ++i) {
                String proposed = info.name() + "_" + i;
                if (already.contains(proposed)) continue;
                localGroups.add(new FieldInfo(proposed, info.type()));
                continue block0;
            }
        }
        return localGroups;
    }

    private int fillPositions(Pipe[] pipes, String[] joinOnFields) {
        int i;
        int i2;
        HashMap<String, Integer> joinPositions = new HashMap<String, Integer>();
        HashSet<String> joinOnSet = Sets.newHashSet(joinOnFields);
        for (i2 = 0; i2 < pipes.length; ++i2) {
            Preconditions.checkArgument((boolean)this.innerFields[0].timestamp().equals((Object)this.innerFields[i2].timestamp()), (Object)"BUG: timestamp clauses must match");
            this.positions[i2] = new int[this.innerFields[i2].size()];
        }
        for (i2 = 0; i2 < pipes.length; ++i2) {
            for (int j = 0; j < this.innerFields[i2].timestamp().size(); ++j) {
                this.positions[i2][j] = j;
            }
        }
        int current = this.innerFields[0].timestamp().size();
        for (i = 0; i < pipes.length; ++i) {
            current = this.fillClauseInfo(this.innerFields[i].group(), joinPositions, joinOnSet, i, current, this.innerFields[i].timestamp().size());
        }
        for (i = 0; i < pipes.length; ++i) {
            current = this.fillClauseInfo(this.innerFields[i].select(), joinPositions, joinOnSet, i, current, this.innerFields[i].timestamp().size() + this.innerFields[i].group().size());
        }
        return current;
    }

    private int fillClauseInfo(ClauseInfo clause, Map<String, Integer> joinPositions, Set<String> joinOnSet, int i, int current, int offset) {
        int j = offset;
        for (FieldInfo info : clause) {
            String name = info.name();
            if (joinOnSet.contains(name)) {
                if (joinPositions.get(name) != null) {
                    this.positions[i][j++] = joinPositions.get(name);
                    continue;
                }
                int n = j++;
                int n2 = current++;
                this.positions[i][n] = n2;
                joinPositions.put(name, n2);
                continue;
            }
            this.positions[i][j++] = current++;
        }
        return current;
    }

    private static SelectClause makeSelect(CompilerContext src, String[] joinOn, Metadata meta) throws PipeException {
        CompilerContext newSrc = src.newSource(meta);
        NamedExpression[] joinExprs = new NamedExpressionImpl[joinOn.length];
        for (int j = 0; j < joinOn.length; ++j) {
            joinExprs[j] = new NamedExpressionImpl((Expression)newSrc.compile((AstNode)new PropertyNode(null, null, joinOn[j])), joinOn[j]);
        }
        return new SelectClauseImpl(joinExprs);
    }

    @Override
    public void flush(Sink sink, Long time, Iterable ... events) {
        ArrayList<Object> rowList = new ArrayList<Object>();
        for (Iterable event : events) {
            if (event instanceof RowList) {
                rowList.add((RowList)event);
                continue;
            }
            if (event != null) continue;
            rowList.add(new ArrayRowList(new Row[0]));
        }
        List<Row> rows = this.calculate(rowList.toArray(new RowList[0]));
        sink.onEvent(this.fields, (RowList)new ArrayRowList(rows));
    }

    private List<Row> calculate(RowList[] es) {
        LinkedHashMap<Row, List[]> map = new LinkedHashMap<Row, List[]>();
        for (int i = 0; i < es.length; ++i) {
            for (int j = 0; j < es[i].size(); ++j) {
                Row row = es[i].get(j);
                Row on = (Row)this.joinOn[i].eval(null, (Object)row);
                List[] list = map.computeIfAbsent(on, x -> new List[es.length]);
                if (list[i] == null) {
                    list[i] = new ArrayList();
                }
                list[i].add(row);
            }
        }
        ArrayList<Row> list = new ArrayList<Row>();
        Row[] current = new Row[es.length];
        for (Map.Entry entry : map.entrySet()) {
            this.backtrack(list, 0, (List[])entry.getValue(), current);
        }
        return list;
    }

    private void backtrack(List<Row> list, int index, List<Row>[] rows, Row[] current) {
        if (index >= rows.length) {
            this.sendRow(list, current);
            return;
        }
        if (rows[index] != null) {
            Iterator<Row> iterator = rows[index].iterator();
            while (iterator.hasNext()) {
                Row row;
                current[index] = row = iterator.next();
                this.backtrack(list, index + 1, rows, current);
            }
        } else if (index > 0 && this.left || index < rows.length - 1 && this.right) {
            current[index] = null;
            this.backtrack(list, index + 1, rows, current);
        }
    }

    private void sendRow(List<Row> list, Row ... rows) {
        Object[] values = new Object[this.size];
        for (int i = 0; i < this.positions.length; ++i) {
            this.fill(i, values, rows[i]);
        }
        list.add((Row)new ArrayRow(values));
    }

    private void fill(int k, Object[] values, Row row) {
        if (row == null) {
            return;
        }
        int i = 0;
        for (Object obj : row) {
            int pos;
            if ((pos = this.positions[k][i++]) == -1) continue;
            values[pos] = obj;
        }
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return new CombiningPropertyVisitor((PropertyVisitor[])Streams.zip(Arrays.stream(this.pipes), Arrays.stream(this.joinOn), (p, j) -> {
            PropertyVisitor v = p.visit(parent, visitor);
            j.visit(parent, v);
            return v;
        }).toArray(PropertyVisitor[]::new));
    }
}

