/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.stateful.fork.JoinPipe;
import net.intelie.pipes.stateful.fork.UnionPipe;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Documentation;

public abstract class MakePipe
implements Function {
    private static final long serialVersionUID = 1L;

    public Object declare(ArgQueue queue) throws PipeException {
        String[] fields = MakePipe.getFields(queue);
        Pipe[] pipes = (Pipe[])queue.array(Pipe.class);
        PipeException.check((pipes.length > 0 ? 1 : 0) != 0, (Object)"Must pass at least one pipe.");
        if (pipes.length == 1) {
            return pipes[0];
        }
        return this.makePipe(queue.context(), fields, pipes);
    }

    private static String[] getFields(ArgQueue queue) throws PipeException {
        String safe;
        ArrayList<String> list = new ArrayList<String>();
        while (queue.hasNext() && (safe = (String)queue.constantValue((Type)Type.STRING).getSafe()) != null) {
            list.add(safe);
        }
        return list.toArray(new String[0]);
    }

    public abstract String innerName();

    public abstract Pipe makePipe(CompilerContext var1, String[] var2, Pipe[] var3) throws PipeException;

    public String name() {
        return "@make" + this.innerName();
    }

    public String description() {
        return this.name();
    }

    public HelpData help() {
        return Documentation.current().makeHelp("@make" + this.innerName(), "pipe-make" + this.innerName());
    }

    public static class LRJoin
    extends MakePipe {
        private static final long serialVersionUID = 1L;

        @Override
        public String innerName() {
            return "lrjoin";
        }

        @Override
        public Pipe makePipe(CompilerContext context, String[] fields, Pipe[] pipes) throws PipeException {
            return new JoinPipe(context, true, true, fields, pipes);
        }
    }

    public static class RJoin
    extends MakePipe {
        private static final long serialVersionUID = 1L;

        @Override
        public String innerName() {
            return "rjoin";
        }

        @Override
        public Pipe makePipe(CompilerContext context, String[] fields, Pipe[] pipes) throws PipeException {
            return new JoinPipe(context, false, true, fields, pipes);
        }
    }

    public static class LJoin
    extends MakePipe {
        private static final long serialVersionUID = 1L;

        @Override
        public String innerName() {
            return "ljoin";
        }

        @Override
        public Pipe makePipe(CompilerContext context, String[] fields, Pipe[] pipes) throws PipeException {
            return new JoinPipe(context, true, false, fields, pipes);
        }
    }

    public static class Join
    extends MakePipe {
        private static final long serialVersionUID = 1L;

        @Override
        public String innerName() {
            return "join";
        }

        @Override
        public Pipe makePipe(CompilerContext context, String[] fields, Pipe[] pipes) throws PipeException {
            return new JoinPipe(context, false, false, fields, pipes);
        }
    }

    public static class Union
    extends MakePipe {
        private static final long serialVersionUID = 1L;

        @Override
        public String innerName() {
            return "union";
        }

        @Override
        public Pipe makePipe(CompilerContext context, String[] fields, Pipe[] pipes) throws PipeException {
            return new UnionPipe(context, pipes);
        }
    }
}

