/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateful.fork;

import java.util.ArrayList;
import java.util.Arrays;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.stateful.fork.CombiningOutput;
import net.intelie.pipes.stateful.fork.CombiningPropertyVisitor;
import net.intelie.pipes.types.CompositeInfo;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.MapRowList;

public class UnionOutput
extends CombiningOutput {
    private static final long serialVersionUID = 1L;
    private final Pipe[] pipes;
    private final RowFields fields;
    private final RowFields[] innerFields;

    public UnionOutput(Metadata old, Pipe ... pipes) throws PipeException {
        super(UnionOutput.decideMetadata(old, pipes));
        this.pipes = pipes;
        this.fields = this.metadata().getRowFields();
        this.innerFields = new RowFields[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            this.innerFields[i] = pipes[i].metadata().getRowFields();
        }
    }

    private static Metadata decideMetadata(Metadata old, Pipe ... pipes) throws PipeException {
        if (pipes.length == 0) {
            throw new PipeException((Object)"Union operation must have at least one pipe");
        }
        Type type = pipes[0].metadata().type();
        long weight = 0L;
        ArrayList outputs = new ArrayList();
        ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
        boolean safe = false;
        for (Pipe pipe : pipes) {
            Metadata other = pipe.metadata();
            type = Type.min((Type)type, (Type)other.type());
            outputs.addAll(other.output());
            windows.add(other.window());
            weight += other.weight();
            safe |= other.safe();
        }
        if (!RowType.hasFields((Type)type)) {
            type = Type.OBJECT;
        }
        return old.withType(type).withSafe(safe).withWeight(weight).withWindow((WindowInfo)new CompositeInfo(windows)).withOutput(outputs);
    }

    @Override
    public void flush(Sink sink, Long time, Iterable ... events) {
        if (this.fields == null) {
            ArrayList objects = new ArrayList();
            for (int i = 0; i < events.length; ++i) {
                Iterable event = events[i];
                if (events[i] instanceof RowList && this.innerFields[i] != null) {
                    objects.addAll(new MapRowList(this.innerFields[i], (RowList)events[i]));
                    continue;
                }
                if (event == null) continue;
                Iterables.addAll(objects, event);
            }
            sink.onRaw((RawEvent)new ArrayRawEvent(objects));
        } else {
            ArrayList rows = new ArrayList();
            for (Iterable event : events) {
                if (!(event instanceof RowList)) continue;
                Iterables.addAll(rows, event);
            }
            sink.onEvent(this.metadata().getRowFields(), (RowList)new ArrayRowList(rows));
        }
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return new CombiningPropertyVisitor((PropertyVisitor[])Arrays.stream(this.pipes).map(p -> p.visit(parent, visitor)).toArray(PropertyVisitor[]::new));
    }
}

