/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.ArrayRawEvent;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.Row;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Sink;
import net.intelie.pipes.StatelessPipe;
import net.intelie.pipes.guava.collect.Lists;
import net.intelie.pipes.model.BaseInstance;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;

public abstract class BaseStatelessPipe
implements StatelessPipe {
    private static final long serialVersionUID = 1L;
    private final StatelessPipeEvaluable evaluable;
    private final Metadata metadata;
    private final boolean mustAddTimestamp;

    public BaseStatelessPipe(CompilerContext config, StatelessPipeEvaluable evaluable) throws PipeException {
        this(config.metadata(), evaluable);
    }

    public BaseStatelessPipe(Metadata metadata, StatelessPipeEvaluable evaluable) {
        this(metadata, true, evaluable);
    }

    public BaseStatelessPipe(Metadata metadata, boolean resetWeights, StatelessPipeEvaluable evaluable) {
        if (resetWeights) {
            metadata = metadata.resetWeights();
        }
        metadata = metadata.withType(evaluable.type().type());
        this.evaluable = evaluable;
        RowFields fields = metadata.getRowFields();
        this.mustAddTimestamp = fields != null && evaluable.supportsTimestamp();
        this.metadata = this.mustAddTimestamp ? metadata.withType((Type)new RowType(new RowFields(Row.TIMESTAMP_CLAUSE, fields.group(), fields.select()))) : metadata;
    }

    public static String toString(boolean parens, String left, Object right) {
        return left + (parens ? "(" : " ") + right + (parens ? ")" : "");
    }

    public StatelessPipeEvaluable evaluable() {
        return this.evaluable;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public boolean split() {
        return false;
    }

    public Pipe mapper() {
        return this;
    }

    public Pipe reducer() {
        return new EmptyPipe(this.metadata(), new Window[0]);
    }

    public PipeInstance newInstance(Sink listener) {
        return new MyInstance(listener);
    }

    public String toString(boolean parens) {
        return this.evaluable.toString(parens);
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean validateExtracted(List list) {
        return true;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.evaluable.visit(parent, visitor);
    }

    private class MyInstance
    extends BaseInstance {
        private final Sink listener;
        private final RowFields fields;

        public MyInstance(Sink listener) {
            this.listener = listener;
            this.fields = BaseStatelessPipe.this.metadata().getRowFields();
        }

        @Override
        public void flowMany(Iterable iterable) {
            iterable = BaseStatelessPipe.this.evaluable.eval(BaseStatelessPipe.this.mustAddTimestamp, null, iterable);
            if (iterable == null) {
                return;
            }
            if (this.fields != null) {
                List<Row> extracted = this.extract(iterable);
                if (BaseStatelessPipe.this.validateExtracted(extracted)) {
                    this.listener.onEvent(this.fields, (RowList)new ArrayRowList(extracted));
                }
            } else {
                ArrayList extracted = Lists.newArrayList(iterable);
                if (BaseStatelessPipe.this.validateExtracted(extracted)) {
                    this.listener.onRaw((RawEvent)new ArrayRawEvent(extracted));
                }
            }
        }

        private List<Row> extract(Iterable iterable) {
            ArrayList<Row> rows = new ArrayList<Row>();
            for (Object o : iterable) {
                if (!(o instanceof Row)) continue;
                rows.add((Row)o);
            }
            return rows;
        }
    }
}

