/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.modules.FallbackToUnderscore;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ConcatIterable;

@Export(value={"@chain"})
@Help(key="pipe-chain")
public class ChainPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public ChainPipe(ArgQueue queue) throws PipeException {
        super(queue.context(), (StatelessPipeEvaluable)new MyEvaluable(queue));
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final Scalar<Iterable> expr;
        private final SeqType type;

        public MyEvaluable(ArgQueue queue) throws PipeException {
            this.expr = (Scalar)queue.scalar((Type)Type.SEQ).getOptional(new FallbackToUnderscore(Type.SEQ));
            SeqType extracted = (SeqType)Type.extract((Type)this.expr.type(), SeqType.class);
            this.type = new SeqType(extracted.type());
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            ArrayList<Object> iterables = new ArrayList<Object>();
            for (Object obj : iterable) {
                iterables.add(this.expr.eval(parent, obj));
            }
            return new ConcatIterable(iterables);
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            return this.expr.visit(parent, visitor);
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@chain", this.expr);
        }
    }
}

