/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.FilterIterable;

@Export(value={"@filter"})
@Help(key="pipe-filter")
public class FilterPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public FilterPipe(ArgQueue queue) throws PipeException {
        super(queue.context(), (StatelessPipeEvaluable)new MyEvaluable(queue));
    }

    @Override
    public boolean validateExtracted(List list) {
        return list.size() > 0;
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final Scalar<Boolean> expr;
        private final SeqType type;

        public MyEvaluable(ArgQueue queue) throws PipeException {
            this.expr = (Scalar)queue.scalar((Type)Type.BOOLEAN).get();
            this.type = new SeqType(queue.context().metadata().type());
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            return new FilterIterable<Object>(iterable, x -> Boolean.TRUE.equals(this.expr.eval(parent, x)));
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            this.expr.visit(parent, visitor);
            return visitor;
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@filter", this.expr);
        }
    }
}

