/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.Help;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.model.NamedExpressionImpl;
import net.intelie.pipes.model.RawValue;
import net.intelie.pipes.modules.FallbackToNamed;
import net.intelie.pipes.modules.FallbackToUnderscore;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ConcatIterable;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.TransformIterable;

@Export(value={"@for"})
@Help(key="pipe-for")
public class ForPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public ForPipe(ArgQueue queue) throws PipeException {
        super(queue.context(), (StatelessPipeEvaluable)new MyEvaluable(queue));
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final Property<Double> timestamp;
        private final NamedExpression expr;
        private final NamedExpression impl;
        private final NamedExpression[] additional;
        private final SeqType type;
        private final int size;

        public MyEvaluable(ArgQueue queue) throws PipeException {
            this.timestamp = queue.context().timestamp();
            this.expr = (NamedExpression)queue.scalar((Type)Type.SEQ).getSafe(NamedExpression.class, (Fallback)new Fallback<NamedExpression>(){

                public NamedExpression create(ArgQueue queue) throws PipeException {
                    return new NamedExpressionImpl((Expression)queue.scalar((Type)Type.SEQ).getOptional(new FallbackToUnderscore(Type.SEQ)));
                }
            });
            this.impl = new NamedExpressionImpl((Expression<?>)new RawValue(((SeqType)Type.extract((Type)this.expr.type(), SeqType.class)).type()), this.expr.originalName(), this.expr.expand());
            this.additional = (NamedExpression[])queue.scalar((Type)Type.OBJECT).arraySafe(NamedExpression.class, (Fallback)new FallbackToNamed((Level)Level.SCALAR));
            this.validateImpls();
            RowType rowType = new RowType(this.computeFields());
            this.type = new SeqType((Type)rowType);
            this.size = rowType.fields().size();
        }

        private void validateImpls() throws PipeException {
            this.impl.validateExpansionOfRawTypes();
            for (NamedExpression namedExpression : this.additional) {
                namedExpression.validateExpansionOfRawTypes();
            }
        }

        private RowFields computeFields() {
            ArrayList fields = new ArrayList();
            fields.addAll(this.impl.info());
            for (NamedExpression expression : this.additional) {
                fields.addAll(expression.info());
            }
            return new RowFields(new ClauseInfo(new FieldInfo[0]), new ClauseInfo(new FieldInfo[0]), new ClauseInfo(fields));
        }

        @Override
        public Iterable eval(boolean withTimestamp, Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            ArrayList<Iterable> rows = new ArrayList<Iterable>();
            for (Object obj : iterable) {
                rows.add(this.evalSingle(withTimestamp, parent, obj));
            }
            return new ConcatIterable(rows);
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            this.timestamp.visit(parent, visitor);
            for (NamedExpression expression : this.additional) {
                expression.visit(parent, visitor);
            }
            this.impl.visit(parent, this.expr.visit(parent, visitor));
            return visitor.newScope();
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        private Iterable evalSingle(boolean withTimestamp, Scope parent, Object obj) {
            Iterable eval = (Iterable)this.expr.eval(parent, obj);
            if (eval == null) {
                return null;
            }
            UnsafeRow row = new UnsafeRow(this.size + (withTimestamp ? 1 : 0));
            int i = 0;
            if (withTimestamp) {
                row.set(i++, this.timestamp.eval(parent, obj));
            }
            i += this.impl.size();
            for (NamedExpression expression : this.additional) {
                i = expression.evalUnsafe(parent, obj, row, i);
            }
            return new TransformIterable(parent, eval, new ForEvaluable(row, withTimestamp));
        }

        @Override
        public boolean supportsTimestamp() {
            return true;
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@for", this.expr + (this.additional.length > 0 ? ", " + Iterables.join((String)", ", (Object[])this.additional) : ""));
        }

        private class ForEvaluable
        implements Evaluable {
            private static final long serialVersionUID = 1L;
            private final UnsafeRow row;
            private final boolean withTimestamp;

            public ForEvaluable(UnsafeRow row, boolean withTimestamp) {
                this.row = row;
                this.withTimestamp = withTimestamp;
            }

            public Object eval(Scope parent, Object obj) {
                MyEvaluable.this.impl.evalUnsafe(parent, obj, this.row, this.withTimestamp ? 1 : 0);
                return this.row.toRow();
            }

            public String toString() {
                return MyEvaluable.this.toString(true);
            }
        }
    }
}

