/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.model.TopLevelExpression;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={"@simple"})
@Help(key="pipe-default")
public class ItemPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public ItemPipe(CompilerContext config, TopLevelExpression query) throws PipeException {
        super(config, (StatelessPipeEvaluable)new MyEvaluable(query));
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final TopLevelExpression query;
        private final SeqType type;

        public MyEvaluable(TopLevelExpression query) {
            this.query = query;
            this.type = new SeqType((Type)query.rowType());
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        @Override
        public boolean justMap() {
            return true;
        }

        @Override
        public String toString(boolean parens) {
            return this.query + " every item";
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            ArrayList<ArrayRow> rows = new ArrayList<ArrayRow>();
            for (Object o : iterable) {
                ArrayRow eval = this.query.evalSingle(parent, o);
                rows.add(eval);
            }
            return rows;
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            return this.query.visit(parent, visitor);
        }
    }
}

