/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.Help;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.model.SelectClauseImpl;
import net.intelie.pipes.modules.FallbackToNamed;
import net.intelie.pipes.simple.Window;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.EmptyPipe;
import net.intelie.pipes.types.CompositeInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.util.ConstantHelper;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.MapRow;

@Export(value={"@meta"})
@Help(key="pipe-meta")
public class MetaPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;
    private final SelectClause select;
    private final Window window;

    public MetaPipe(ArgQueue queue) throws PipeException {
        this(queue.metadata(), (Window)queue.getSafe(Window.class), new SelectClauseImpl((NamedExpression[])queue.scalar((Type)Type.OBJECT).arraySafe(NamedExpression.class, (Fallback)new FallbackToNamed((Level)Level.SCALAR))));
    }

    public MetaPipe(Metadata metadata, Window window, SelectClause select) throws PipeException {
        super(MetaPipe.decideMeta(metadata, window, select), false, new EmptyPipe.MyEvaluable(metadata.type()));
        this.window = window;
        this.select = select;
    }

    private static Metadata decideMeta(Metadata old, Window window, SelectClause select) throws PipeException {
        PipeException.check((boolean)select.realLevel().isAssignableTo((Level)Level.CONSTANT), (Object)"Meta fields must be stricly constant. Use const() function if needed.");
        old = old.resetWeights(0L);
        if (window != null) {
            LinkedHashSet infos = new LinkedHashSet();
            for (Output output : old.output()) {
                Iterables.addAll(infos, (Iterable)window.info(output));
            }
            old = old.withWindow((WindowInfo)new CompositeInfo(new ArrayList(infos)));
        }
        LinkedHashMap newMap = new LinkedHashMap(old.custom());
        newMap.putAll(new MapRow(new RowFields(select.info()), (Row)ConstantHelper.evaluate((Expression)select)));
        return old.withCustom(newMap);
    }

    @Override
    public String toString() {
        return "@meta" + (this.select.size() > 0 ? " " + this.select : "") + (this.window != null ? " " + this.window : "");
    }
}

