/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={"@skipwhile"})
@Help(key="pipe-skipwhile")
public class SkipWhilePipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public SkipWhilePipe(ArgQueue queue) throws PipeException {
        this(queue.context(), (Aggregation<Boolean>)((Aggregation)queue.aggregation((Type)Type.BOOLEAN).get()));
    }

    public SkipWhilePipe(CompilerContext config, Aggregation<Boolean> expr) throws PipeException {
        super(config, (StatelessPipeEvaluable)new MyEvaluable(config, expr));
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final SeqType type;
        private final Aggregation<Boolean> expr;

        public MyEvaluable(CompilerContext config, Aggregation<Boolean> expr) {
            this.type = new SeqType(config.metadata().type());
            this.expr = expr;
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            ArrayList list = new ArrayList();
            State state = this.expr.newState(0);
            FullMerger merger = this.expr.newMerger();
            for (Object obj : iterable) {
                state.yield(parent, obj);
                merger.push(state.flip());
                if (Boolean.TRUE.equals(this.expr.eval(parent, merger.get(), null))) continue;
                list.add(obj);
            }
            return list;
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            this.expr.visit(parent, visitor);
            return visitor;
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@skipwhile", this.expr);
        }
    }
}

