/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.SliceIterable;

@Export(value={"@slice"})
@Help(key="pipe-slice")
public class SlicePipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public SlicePipe(ArgQueue queue) throws PipeException {
        this(queue.context(), queue.groupBy(), SlicePipe.makeLong((Double)queue.constantValue((Type)Type.NUMBER).getOptional()), SlicePipe.makeLong((Double)queue.constantValue((Type)Type.NUMBER).getOptional()), SlicePipe.makeLong((Double)queue.constantValue((Type)Type.NUMBER).getOptional()));
    }

    public SlicePipe(CompilerContext config, GroupBy group, Long start, Long end, Long step) throws PipeException {
        super(config, (StatelessPipeEvaluable)new MyEvaluable(config, group, start, end, step));
    }

    public static Long makeLong(Double value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final SeqType type;
        private final long start;
        private final Long end;
        private final long step;
        private final GroupBy group;

        public MyEvaluable(CompilerContext config, GroupBy group, Long start, Long end, Long step) {
            this.type = new SeqType(config.metadata().type());
            this.group = group;
            this.start = start != null ? start : 0L;
            this.end = end;
            this.step = step != null ? step : 1L;
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            if (this.group.size() == 0) {
                return new SliceIterable(iterable, this.start, this.end, this.step);
            }
            ArrayList list = new ArrayList();
            GroupBy.State state = this.group.newState(key -> new Bucket());
            for (Object obj : iterable) {
                boolean stepOk;
                Bucket bucket = (Bucket)state.get(parent, obj);
                long count = bucket.count++;
                boolean startOk = this.start <= count;
                boolean upperOk = this.end == null || count < this.end;
                boolean bl = stepOk = (count - this.start) % this.step == 0L;
                if (!startOk || !upperOk || !stepOk) continue;
                list.add(obj);
            }
            return list;
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            this.group.visit(parent, visitor);
            return visitor;
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@slice", this.start + ", " + this.end + ", " + this.step + (this.group.size() > 0 ? " " + this.group : ""));
        }
    }

    private static class Bucket {
        private long count = 0L;

        private Bucket() {
        }
    }
}

